/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import de.markusbordihn.easynpc.entity.easynpc.data.SpawnData;
import de.markusbordihn.easynpc.entity.easynpc.data.SpawnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.BaseTickHandler;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;

public interface EasyNPCBase<E extends PathfinderMob>
extends Saddleable,
EasyNPC<E>,
ActionHandler<E>,
ActionEventData<E>,
AttackData<E>,
AttributeData<E>,
BaseTickHandler<E>,
ConfigurationData<E>,
DialogData<E>,
GuiData<E>,
NavigationData<E>,
ConfigData<E>,
ObjectiveData<E>,
OwnerData<E>,
PresetData<E>,
ProfessionData<E>,
RenderData<E>,
SkinData<E>,
SoundData<E>,
SpawnData<E>,
SpawnerData<E>,
TickerData<E>,
TradingData<E>,
VariantData<E> {
    public static void registerEasyNPCDataSerializers() {
        log.info("Register data serializers ...");
        ActionEventData.registerActionEventDataSerializer();
        DialogData.registerDialogDataSerializer();
        ObjectiveData.registerObjectiveDataSerializer();
        ProfessionData.registerProfessionDataSerializer();
        RenderData.registerRenderDataSerializer();
        SoundData.registerSoundDataSerializer();
        SkinData.registerSkinDataSerializer();
        SpawnerData.registerSpawnerDataSerializer();
        TradingData.registerTradingDataSerializer();
    }

    public static void registerEasyNPCSyncedData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        AttackData.registerSyncedAttackData(map, entityClass);
        AttributeData.registerSyncedAttributeData(map, entityClass);
        NavigationData.registerSyncedNavigationData(map, entityClass);
        OwnerData.registerSyncedOwnerData(map, entityClass);
        ProfessionData.registerSyncedProfessionData(map, entityClass);
        RenderData.registerSyncedRenderData(map, entityClass);
        SkinData.registerSyncedSkinData(map, entityClass);
        SoundData.registerSyncedSoundData(map, entityClass);
        TradingData.registerSyncedTradingData(map, entityClass);
        VariantData.registerSyncedVariantData(map, entityClass);
    }

    default public void registerEasyNPCDefaultHandler(Enum<?> variant) {
        SoundData soundData;
        AttributeData attributeData;
        log.info("Register default handler for {} with variant {} ...", (Object)this, variant);
        VariantData variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.setVariant(variant);
        }
        if (this.isServerSide()) {
            SpawnerData spawnerData;
            ObjectiveData objectiveData;
            DialogData dialogData;
            log.info("Define custom server-side data for {} ...", (Object)this);
            ActionEventData actionEventData = this.getEasyNPCActionEventData();
            if (actionEventData != null) {
                actionEventData.defineCustomActionData();
            }
            if ((dialogData = this.getEasyNPCDialogData()) != null) {
                dialogData.defineCustomDialogData();
            }
            if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
                objectiveData.defineCustomObjectiveData();
            }
            if ((spawnerData = this.getEasyNPCSpawnerData()) != null) {
                spawnerData.defineCustomSpawnerData();
            }
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.registerDefaultAttributeData(variant);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.registerDefaultSoundData(variant);
        }
    }

    default public void defineEasyNPCBaseSyncedData() {
        TradingData tradingData;
        SoundData soundData;
        SkinData skinData;
        RenderData renderData;
        ProfessionData professionData;
        OwnerData ownerData;
        NavigationData navigationData;
        DialogData dialogData;
        AttributeData attributeData;
        AttackData attackData;
        ActionEventData actionEventData;
        log.debug("Define synced data for {}", (Object)this);
        VariantData variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.defineSynchedVariantData();
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.defineSynchedActionData();
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.defineSynchedAttackData();
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.defineSynchedAttributeData();
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.defineSynchedDialogData();
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.defineSynchedNavigationData();
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.defineSynchedOwnerData();
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.defineSynchedProfessionData();
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.defineSynchedRenderData();
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.defineSynchedSkinData();
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.defineSynchedSoundData();
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.defineSynchedTradingData();
        }
    }

    default public void addEasyNPCBaseAdditionalSaveData(CompoundTag compoundTag) {
        VariantData variantData;
        TradingData tradingData;
        SpawnerData spawnerData;
        SoundData soundData;
        SkinData skinData;
        RenderData renderData;
        ProfessionData professionData;
        OwnerData ownerData;
        ObjectiveData objectiveData;
        NavigationData navigationData;
        DialogData dialogData;
        ConfigData configData;
        AttributeData attributeData;
        AttackData attackData;
        log.debug("Add additional save data for {}", (Object)this);
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.addAdditionalActionData(compoundTag);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.addAdditionalAttackData(compoundTag);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.addAdditionalAttributeData(compoundTag);
        }
        if ((configData = this.getEasyNPCConfigData()) != null) {
            configData.addAdditionalConfigData(compoundTag);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.addAdditionalDialogData(compoundTag);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.addAdditionalNavigationData(compoundTag);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.addAdditionalObjectiveData(compoundTag);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.addAdditionalOwnerData(compoundTag);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.addAdditionalProfessionData(compoundTag);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.addAdditionalRenderData(compoundTag);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.addAdditionalSkinData(compoundTag);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.addAdditionalSoundData(compoundTag);
        }
        if ((spawnerData = this.getEasyNPCSpawnerData()) != null) {
            spawnerData.addAdditionalSpawnerData(compoundTag);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.addAdditionalTradingData(compoundTag);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.addAdditionalVariantData(compoundTag);
        }
    }

    default public void readEasyNPCBaseAdditionalSaveData(CompoundTag compoundTag) {
        TradingData tradingData;
        SpawnerData spawnerData;
        SoundData soundData;
        SkinData skinData;
        RenderData renderData;
        ProfessionData professionData;
        OwnerData ownerData;
        ObjectiveData objectiveData;
        NavigationData navigationData;
        DialogData dialogData;
        AttributeData attributeData;
        AttackData attackData;
        ActionEventData actionEventData;
        VariantData variantData;
        log.debug("Read additional save data for {} ...", (Object)this);
        ConfigData configData = this.getEasyNPCConfigData();
        if (configData != null) {
            configData.readAdditionalConfigData(compoundTag);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.readAdditionalVariantData(compoundTag);
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.readAdditionalActionData(compoundTag);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.readAdditionalAttackData(compoundTag);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.readAdditionalAttributeData(compoundTag);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.readAdditionalDialogData(compoundTag);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.readAdditionalNavigationData(compoundTag);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.readAdditionalObjectiveData(compoundTag);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.readAdditionalOwnerData(compoundTag);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.readAdditionalProfessionData(compoundTag);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.readAdditionalRenderData(compoundTag);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.readAdditionalSkinData(compoundTag);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.readAdditionalSoundData(compoundTag);
        }
        if ((spawnerData = this.getEasyNPCSpawnerData()) != null) {
            spawnerData.readAdditionalSpawnerData(compoundTag);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.readAdditionalTradingData(compoundTag);
        }
        if (objectiveData != null) {
            objectiveData.readAdditionalObjectiveData(compoundTag);
        }
    }
}

