/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface VariantData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TAG = "Variant";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Variant Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT, SynchedEntityData.m_135353_(EasyNPC.getSynchedEntityDataClass(), (EntityDataSerializer)EntityDataSerializers.f_135030_));
    }

    default public Enum<?> getDefaultVariant() {
        return Variant.STEVE;
    }

    default public Enum<?> getVariant() {
        return this.getVariant((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT));
    }

    default public void setVariant(Enum<?> variant) {
        this.setSynchedEntityData(SynchedDataIndex.VARIANT, variant != null ? variant.name() : "");
    }

    default public void setVariant(String name) {
        Enum<?> variant = this.getVariant(name);
        if (variant != null) {
            this.setVariant(variant);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public Enum<?> getVariant(String name) {
        return Variant.valueOf(name);
    }

    default public Enum<?>[] getVariants() {
        return Variant.values();
    }

    default public Stream<String> getVariantNames() {
        return Stream.of(this.getVariants()).map(Enum::name);
    }

    default public Component getVariantName() {
        Enum<?> variant = this.getVariant();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEasyNPCTypeName();
    }

    default public boolean hasVariantCrossedArms() {
        return this.hasVariantCrossedArms(this.getVariant());
    }

    default public boolean hasVariantCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantSaddled() {
        return this.hasVariantSaddled(this.getVariant());
    }

    default public boolean hasVariantSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public void defineSynchedVariantData() {
        this.defineSynchedEntityData(SynchedDataIndex.VARIANT, this.getDefaultVariant().name());
    }

    default public void addAdditionalVariantData(CompoundTag compoundTag) {
        if (this.getVariant() != null) {
            compoundTag.m_128359_(EASY_NPC_DATA_VARIANT_TAG, this.getVariant().name());
        }
    }

    default public void readAdditionalVariantData(CompoundTag compoundTag) {
        String variant;
        if (compoundTag.m_128441_(EASY_NPC_DATA_VARIANT_TAG) && !(variant = compoundTag.m_128461_(EASY_NPC_DATA_VARIANT_TAG)).isEmpty()) {
            this.setVariant(this.getVariant(variant));
        }
    }

    public static enum Variant {
        STEVE,
        ALEX;

    }
}

