/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import net.minecraft.world.entity.PathfinderMob;

public interface BaseTickHandler<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final int BASE_TICK = 16;
    public static final int TRADING_BASE_TICK = Math.round(75.0f) - 10;

    default public void handleBaseTick() {
        this.getProfiler().m_6180_("npcBaseTick");
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.BASE_TICK, 16)) {
            ActionHandler actionHandler = this.getEasyNPCActionHandler();
            actionHandler.checkDistanceActions();
            if (tickerData.checkAndIncreaseTicker(TickerType.TRADING_BASE_TICK, TRADING_BASE_TICK)) {
                TradingData tradingData = this.getEasyNPCTradingData();
                if (tradingData.hasTrading()) {
                    actionHandler.checkTradingActions();
                }
                tickerData.resetTicker(TickerType.TRADING_BASE_TICK);
            }
            tickerData.resetTicker(TickerType.BASE_TICK);
        }
        this.getProfiler().m_7238_();
    }
}

