/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final int pageIndex;
    protected final EasyNPC<?> easyNPC;
    protected final Level level;
    protected final Player player;
    protected final SkinModel skinModel;
    protected final UUID uuid;

    public ConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, UUID uuid) {
        this(menuType, windowId, playerInventory, uuid, 0);
    }

    public ConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, UUID uuid, int pageIndex) {
        super(menuType, windowId);
        this.uuid = uuid;
        this.pageIndex = pageIndex;
        this.player = playerInventory.f_35978_;
        this.level = this.player.m_9236_();
        this.easyNPC = this.level.f_46443_ ? LivingEntityManager.getEasyNPCEntityByUUID(uuid) : LivingEntityManager.getEasyNPCEntityByUUID(uuid, (ServerPlayer)this.player);
        this.skinModel = this.easyNPC.getEasyNPCSkinData().getSkinModel();
        if (this.level.f_46443_) {
            log.debug("Open configuration menu {} ({}) for {}: {} with player inventory {}", menuType, (Object)this.pageIndex, (Object)this.uuid, this.easyNPC, (Object)playerInventory);
        }
    }

    public EasyNPC<?> getEasyNPC() {
        return this.easyNPC;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_() && this.easyNPC != null && this.easyNPC.getEntity().m_6084_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }
}

