/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration.trading;

import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.menu.configuration.trading.ItemASlot;
import de.markusbordihn.easynpc.menu.configuration.trading.ItemBSlot;
import de.markusbordihn.easynpc.menu.configuration.trading.ItemResultSlot;
import de.markusbordihn.easynpc.menu.configuration.trading.TradingConfigurationMenu;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class BasicTradingConfigurationMenu
extends TradingConfigurationMenu {
    public static final int TRADING_START_POSITION_Y = 40;
    public static final int TRADING_START_POSITION_X = 30;
    public static final int TRADING_START_POSITION_SECOND_ROW_X = 190;
    public static final int TRADING_SLOT_SIZE = 18;
    public static final int SLOT_SIZE = 18;
    protected static final int TRADING_CONTAINER_SIZE = 36;
    protected final Container tradingContainer;

    public BasicTradingConfigurationMenu(int windowId, Inventory playerInventory, UUID uuid) {
        this((MenuType)ModMenuTypes.BASIC_TRADING_CONFIGURATION_MENU.get(), windowId, playerInventory, uuid);
    }

    public BasicTradingConfigurationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_());
    }

    public BasicTradingConfigurationMenu(MenuType<?> menuType, int windowId, Inventory inventory, UUID uuid) {
        this(menuType, windowId, inventory, (Container)new SimpleContainer(36), uuid);
    }

    public BasicTradingConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, Container tradingContainer, UUID uuid) {
        super(menuType, windowId, playerInventory, uuid, 0);
        MerchantOffers merchantOffers;
        BasicTradingConfigurationMenu.m_38869_((Container)tradingContainer, (int)36);
        this.tradingContainer = tradingContainer;
        if (!this.level.f_46443_ && (merchantOffers = this.getEasyNPC().getEasyNPCTradingData().getTradingOffers()) != null) {
            for (int tradingOffer = 0; tradingOffer < 12 && tradingOffer < merchantOffers.size(); ++tradingOffer) {
                MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOffer);
                this.tradingContainer.m_6836_(tradingOffer * 3, merchantOffer.m_45352_());
                this.tradingContainer.m_6836_(tradingOffer * 3 + 1, merchantOffer.m_45364_());
                this.tradingContainer.m_6836_(tradingOffer * 3 + 2, merchantOffer.m_45368_());
            }
        }
        int slotPositionX = 30;
        int slotPositionY = 40;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = 190;
                slotPositionY = 40;
            }
            this.m_38897_(new ItemASlot(this, tradingContainer, tradingOffer * 3, slotPositionX, slotPositionY));
            this.m_38897_(new ItemBSlot(this, tradingContainer, tradingOffer * 3 + 1, slotPositionX + 18 + 18, slotPositionY));
            this.m_38897_(new ItemResultSlot(this, tradingContainer, tradingOffer * 3 + 2, slotPositionX + 82, slotPositionY));
            slotPositionY += 19;
        }
        int playerInventoryStartPositionY = 159;
        int playerInventoryStartPositionX = 8;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 215;
        int hotbarStartPositionX = 8;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
    }

    public static MenuProvider getMenuProvider(final UUID uuid, final Entity entity) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)("Basic Trades for " + entity.m_7755_().getString()));
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                return new BasicTradingConfigurationMenu(windowId, inventory, uuid);
            }
        };
    }

    @Override
    public void setTradingChanged() {
        if (this.level.f_46443_) {
            return;
        }
        this.getEasyNPC().getEasyNPCTradingData().setBasicTradingOffers(this.tradingContainer);
    }
}

