/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.spawner;

import de.markusbordihn.easynpc.menu.slots.PresetSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SpawnerMenu
extends AbstractContainerMenu {
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int presetItemSlotX = 42;
    public static final int presetItemSlotY = 169;
    protected static final int containerSize = 1;
    private final Container container;
    private final ContainerData data;

    public SpawnerMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(9));
    }

    public SpawnerMenu(int containerId, Inventory playerInventory, Container container, ContainerData containerData) {
        this(null, containerId, playerInventory, container, containerData);
    }

    public SpawnerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(9));
    }

    public SpawnerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, Container container, ContainerData containerData) {
        super(menuType, containerId);
        SpawnerMenu.m_38869_((Container)container, (int)1);
        SpawnerMenu.m_38886_((ContainerData)containerData, (int)9);
        this.container = container;
        this.data = containerData;
        this.m_38897_(new PresetSlot(container, 0, 42, 169));
        int slotSize = 18;
        int slotSpacing = 8;
        int playerInventoryStartPositionX = 90;
        int playerInventoryStartPositionY = 153;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + slotSpacing + inventoryColumn * slotSize, playerInventoryStartPositionY + inventoryRow * slotSize));
            }
        }
        int hotbarStartPositionX = 90;
        int hotbarStartPositionY = 213;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + slotSpacing + playerInventorySlot * slotSize, hotbarStartPositionY));
        }
        this.m_38884_(containerData);
    }

    public boolean m_6875_(Player player) {
        return player != null && player.m_6084_();
    }

    public BlockPos getSpawnerPosition() {
        return new BlockPos(this.data.m_6413_(0), this.data.m_6413_(1), this.data.m_6413_(2));
    }

    public int getSpawnRange() {
        return this.data.m_6413_(3);
    }

    public int getDespawnRange() {
        return this.data.m_6413_(8);
    }

    public int getRequiredPlayerRange() {
        return this.data.m_6413_(4);
    }

    public int getDelay() {
        return this.data.m_6413_(5);
    }

    public int getMaxNearbyEntities() {
        return this.data.m_6413_(6);
    }

    public int getSpawnCount() {
        return this.data.m_6413_(7);
    }

    public ItemStack getPresetItem() {
        return this.container.m_8020_(0);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }
}

