/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelPoseChange
extends NetworkMessage {
    protected final ModelPose modelPose;

    public MessageModelPoseChange(UUID uuid, ModelPose modelPose) {
        super(uuid);
        this.modelPose = modelPose;
    }

    public static MessageModelPoseChange decode(FriendlyByteBuf buffer) {
        return new MessageModelPoseChange(buffer.m_130259_(), (ModelPose)buffer.m_130066_(ModelPose.class));
    }

    public static void encode(MessageModelPoseChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getModelPose());
    }

    public static void handle(MessageModelPoseChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelPoseChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelPoseChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPose modelPose = message.getModelPose();
        if (modelPose == null) {
            log.error("Invalid modelPose {} for {} from {}", (Object)modelPose, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        log.debug("Change modelPose {} for {} from {}", (Object)modelPose, easyNPC, (Object)serverPlayer);
        modelData.setModelPose(modelPose);
        easyNPC.getEntity().m_20124_(Pose.STANDING);
    }

    public ModelPose getModelPose() {
        return this.modelPose;
    }
}

