/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelPositionChange
extends NetworkMessage {
    protected final ModelPart modelPart;
    protected final CustomPosition position;

    public MessageModelPositionChange(UUID uuid, ModelPart modelPart, float x, float y, float z) {
        this(uuid, modelPart, new CustomPosition(x, y, z));
    }

    public MessageModelPositionChange(UUID uuid, ModelPart modelPart, CustomPosition position) {
        super(uuid);
        this.modelPart = modelPart;
        this.position = position;
    }

    public static MessageModelPositionChange decode(FriendlyByteBuf buffer) {
        return new MessageModelPositionChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void encode(MessageModelPositionChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getModelPart());
        buffer.writeFloat(message.getX());
        buffer.writeFloat(message.getY());
        buffer.writeFloat(message.getZ());
    }

    public static void handle(MessageModelPositionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelPositionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelPositionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            return;
        }
        CustomPosition position = message.getPosition();
        if (position == null) {
            log.error("Invalid position {} for {} from {}", (Object)position, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)modelPart, (Object)position, easyNPC, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelHeadPosition(position);
                break;
            }
            case BODY: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelBodyPosition(position);
                break;
            }
            case ARMS: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelArmsPosition(position);
                break;
            }
            case LEFT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftArmPosition(position);
                break;
            }
            case RIGHT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightArmPosition(position);
                break;
            }
            case LEFT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftLegPosition(position);
                break;
            }
            case RIGHT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightLegPosition(position);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
        if (modelData.getModelPose() == ModelPose.CUSTOM && !modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
            easyNPC.getEntity().m_20124_(Pose.STANDING);
        }
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public CustomPosition getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x();
    }

    public float getY() {
        return this.position.y();
    }

    public float getZ() {
        return this.position.z();
    }
}

