/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogButtonType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenDialogButtonEditor
extends NetworkMessage {
    protected final UUID dialogId;
    protected final UUID dialogButtonId;
    protected final ConfigurationType formerConfigurationType;
    protected final int pageIndex;

    public MessageOpenDialogButtonEditor(UUID uuid, UUID dialogId, ConfigurationType formerConfigurationType) {
        this(uuid, dialogId, null, formerConfigurationType, 0);
    }

    public MessageOpenDialogButtonEditor(UUID uuid, UUID dialogId, UUID dialogButtonId, ConfigurationType formerConfigurationType) {
        this(uuid, dialogId, dialogButtonId, formerConfigurationType, 0);
    }

    public MessageOpenDialogButtonEditor(UUID uuid, UUID dialogId, UUID dialogButtonId, ConfigurationType formerConfigurationType, int pageIndex) {
        super(uuid);
        this.dialogId = dialogId;
        this.dialogButtonId = dialogButtonId;
        this.formerConfigurationType = formerConfigurationType;
        this.pageIndex = pageIndex;
    }

    public static MessageOpenDialogButtonEditor decode(FriendlyByteBuf buffer) {
        return new MessageOpenDialogButtonEditor(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130259_(), (ConfigurationType)buffer.m_130066_(ConfigurationType.class), buffer.readInt());
    }

    public static void encode(MessageOpenDialogButtonEditor message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.getDialogId());
        buffer.m_130077_(message.getDialogButtonId());
        buffer.m_130068_((Enum)message.formerConfigurationType);
        buffer.writeInt(message.pageIndex);
    }

    public static void handle(MessageOpenDialogButtonEditor message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageOpenDialogButtonEditor.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageOpenDialogButtonEditor message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id {} for {} from {}", (Object)dialogId, (Object)message, (Object)context);
            return;
        }
        int pageIndex = message.getPageIndex();
        if (pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)pageIndex, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogDataSet dialogDataSet = dialogData.getDialogDataSet();
        if (dialogDataSet == null) {
            log.error("Unable to get valid dialog data set for {} from {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogDataEntry dialogDataEntry = dialogDataSet.getDialog(dialogId);
        if (dialogDataEntry == null) {
            log.error("Unable to get valid dialog data for dialog {} for {} from {}", (Object)uuid, (Object)dialogId, (Object)serverPlayer);
            return;
        }
        UUID dialogButtonId = message.getDialogButtonId();
        if (dialogButtonId != null && dialogButtonId.equals(EMPTY_UUID)) {
            DialogButtonData newDialogButton = new DialogButtonData("Button " + RANDOM.nextInt(1000), DialogButtonType.DEFAULT);
            log.info("Created new dialog button {} for dialog {} for {} from {}", (Object)newDialogButton, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            dialogDataEntry.setButton(newDialogButton);
            dialogButtonId = newDialogButton.getId();
        } else if (dialogButtonId != null && !dialogData.hasDialogButton(dialogId, dialogButtonId)) {
            log.error("Invalid dialog button id {} for {} from {}", (Object)dialogButtonId, (Object)message, (Object)context);
            return;
        }
        ConfigurationType formerConfigurationType = message.getFormerConfigurationType();
        log.info("Open dialog button editor with ref: {} for dialog {} and button {} for {} from {}", (Object)formerConfigurationType, (Object)dialogId, (Object)dialogButtonId, (Object)uuid, (Object)serverPlayer);
        MenuManager.getMenuHandler().openDialogButtonEditorMenu(serverPlayer, easyNPC, dialogId, dialogButtonId, formerConfigurationType, pageIndex);
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public UUID getDialogButtonId() {
        return this.dialogButtonId;
    }

    public ConfigurationType getFormerConfigurationType() {
        return this.formerConfigurationType;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }
}

