/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.handler.OwnerHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class OwnerCommand
extends Command {
    private static final String EASY_NPC_PREFIX = "EasyNPC ";

    private OwnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"owner").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)new EasyNPCArgument()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> OwnerCommand.setOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "target"), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)new EasyNPCArgument()).executes(context -> OwnerCommand.getOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntity((CommandContext<CommandSourceStack>)context, "target")))));
    }

    private static int setOwner(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        if (easyNPC == null || serverPlayer == null) {
            return 0;
        }
        if (!OwnerHandler.setOwner(easyNPC, (LivingEntity)serverPlayer)) {
            OwnerCommand.sendFailureMessage(context, "Failed to set owner for " + easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, "Owner of " + easyNPC + " was changed to " + serverPlayer);
    }

    private static int getOwner(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null) {
            return OwnerCommand.sendFailureMessageNoOwnerData(context, easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, EASY_NPC_PREFIX + easyNPC.getUUID() + " is owned by " + ownerData.getOwner());
    }
}

