/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.client.model.ModModelLayer;
import de.markusbordihn.easynpc.client.renderer.ClientRenderer;
import de.markusbordihn.easynpc.client.screen.ClientScreens;
import de.markusbordihn.easynpc.commands.ModArgumentTypes;
import de.markusbordihn.easynpc.debug.DebugManager;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.item.ModItems;
import de.markusbordihn.easynpc.menu.MenuHandler;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="easy_npc")
public class EasyNPC {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public EasyNPC() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        log.info("Initializing {} (Forge) ...", (Object)"Easy NPC");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
        if (version.isPresent() && "MOD_DEV".equals(version.get())) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Constants.GAME_DIR = FMLPaths.GAMEDIR.get();
        Constants.CONFIG_DIR = FMLPaths.CONFIGDIR.get();
        log.info("{} Event Bus Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        modEventBus.addListener(ModArgumentTypes::registerArgumentTypes);
        log.info("{} Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModEntityType.ENTITY_TYPES.register(modEventBus);
        log.info("{} Blocks ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.BLOCKS.register(modEventBus);
        log.info("{} Blocks Entities ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.BLOCK_ENTITIES.register(modEventBus);
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModItems.ITEMS.register(modEventBus);
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        MenuManager.registerMenuHandler(new MenuHandler());
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        modEventBus.addListener(NetworkHandler::registerNetworkHandler);
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            log.info("{} Client events ...", (Object)"\ud83d\udde3 Register Easy NPC");
            modEventBus.addListener(ModModelLayer::registerEntityLayerDefinitions);
            modEventBus.addListener(ClientRenderer::registerEntityRenderers);
            modEventBus.addListener(ClientScreens::registerScreens);
            modEventBus.addListener(event -> event.enqueueWork(DataFileHandler::registerDataFiles));
            NetworkMessageHandlerManager.registerServerHandler(new ServerNetworkMessageHandler());
        });
    }
}

