/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.Entity;

public class StandardVillagerModel<T extends Entity>
extends VillagerModel<T>
implements EasyNPCModel<T> {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, Rotations> modelPartRotationMap = new EnumMap<ModelPartType, Rotations>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    private final ModelPart arms;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public StandardVillagerModel(ModelPart modelPart) {
        super(modelPart);
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.ARMS, this.arms);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.f_104203_ = headPitch * ((float)Math.PI / 180);
        headPart.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.arms.f_104203_ += 0.4f;
        this.arms.f_104201_ = 5.2f;
        this.body.f_104203_ = 0.5f;
        this.body.f_104201_ = 3.2f;
        this.head.f_104201_ = 4.2f;
        this.leftLeg.f_104201_ = 12.2f;
        this.leftLeg.f_104202_ = 4.0f;
        this.rightLeg.f_104201_ = 12.2f;
        this.rightLeg.f_104202_ = 4.0f;
        return true;
    }

    @Override
    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.modelPartPositionMap.put(modelPartType, customPosition);
    }

    @Override
    public void setDefaultModelPartRotation(ModelPartType modelPartType, Rotations rotations) {
        this.modelPartRotationMap.put(modelPartType, rotations);
    }

    @Override
    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    @Override
    public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.modelPartPositionMap.getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    @Override
    public Rotations getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.modelPartRotationMap.getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    @Override
    public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.getOrDefault((Object)modelPartType, null);
    }
}

