/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.RendererManager;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPCRenderer<E extends PathfinderMob, M extends EntityModel<E>> {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public static boolean renderEntity(PathfinderMob entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        RenderData renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderData() == null || renderData.getRenderData().getRenderType() == RenderType.DEFAULT) {
            return false;
        }
        RenderDataSet renderDataSet = renderData.getRenderData();
        RenderType renderType = renderDataSet.getRenderType();
        EntityType<?> renderEntityType = renderDataSet.getRenderEntityType();
        if (renderType == RenderType.CUSTOM_ENTITY && renderEntityType != null && !RendererManager.isUnsupportedEntityType(renderEntityType)) {
            PathfinderMob customEntity = RendererManager.getPathfinderMob(renderEntityType);
            if (customEntity != null) {
                LivingEntityRenderer<?, ?> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType);
                if (livingEntityRenderer != null) {
                    EasyNPCRenderer.renderCustomLivingEntity(entity, (LivingEntity)customEntity, livingEntityRenderer, entityYaw, partialTicks, poseStack, buffer, packedLight);
                    return true;
                }
                EntityRenderer<?> entityRenderer = RendererManager.getEntityRenderer(renderEntityType);
                if (entityRenderer != null) {
                    EasyNPCRenderer.renderCustomEntity(entity, (Entity)customEntity, entityRenderer, entityYaw, partialTicks, poseStack, buffer, packedLight);
                    return true;
                }
            }
            RendererManager.registerRenderer(renderEntityType, entity.f_19853_);
        }
        return false;
    }

    public static void renderCustomEntity(PathfinderMob entity, Entity customEntity, EntityRenderer<Entity> entityRenderer, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        RendererManager.copyCustomEntityData(entity, customEntity);
        entityRenderer.m_7392_(customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public static void renderCustomLivingEntity(PathfinderMob entity, LivingEntity customEntity, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> livingEntityRenderer, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        RendererManager.copyCustomLivingEntityData(entity, customEntity);
        livingEntityRenderer.m_7392_(customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureByVariant(Enum<?> var1);

    public ResourceLocation getDefaultTexture();

    default public ResourceLocation getTextureOverlayByVariant(Enum<?> variant) {
        return Constants.BLANK_ENTITY_TEXTURE;
    }

    default public ResourceLocation getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getPlayerTexture(SkinData<?> entity) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public <N extends EasyNPC<E>> ResourceLocation getEntityTexture(N easyNPC) {
        SkinData<E> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }

    default public <N extends EasyNPC<E>> ResourceLocation getEntityOverlayTexture(N easyNPC) {
        if (easyNPC.getEasyNPCSkinData().getSkinType() == SkinType.DEFAULT) {
            return this.getTextureOverlayByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        }
        return Constants.BLANK_ENTITY_TEXTURE;
    }

    default public <N extends EasyNPC<E>> ResourceLocation getEntityPlayerTexture(N easyNPC) {
        SkinData<E> skinData = easyNPC.getEasyNPCSkinData();
        return switch (easyNPC.getEasyNPCSkinData().getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.PLAYER_SKIN -> this.getPlayerTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

