/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.base;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.EasyNPCRenderer;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BaseHumanoidMobModelRenderer<E extends EasyNPCBaseModelEntity<E>, V, M extends EntityModel<E>>
extends MobRenderer<E, M>
implements EasyNPCModelRenderer<E, M> {
    protected final Map<V, ResourceLocation> textures;
    protected final Map<V, ResourceLocation> texturesOverlay;
    protected final ResourceLocation defaultTexture;

    public BaseHumanoidMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture) {
        this(context, model, shadowRadius, defaultTexture, null, null);
    }

    public BaseHumanoidMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture, Map<V, ResourceLocation> textures) {
        this(context, model, shadowRadius, defaultTexture, textures, null);
    }

    public BaseHumanoidMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture, Map<V, ResourceLocation> textures, Map<V, ResourceLocation> texturesOverlay) {
        super(context, model, shadowRadius);
        this.defaultTexture = defaultTexture != null ? defaultTexture : Constants.BLANK_ENTITY_TEXTURE;
        this.textures = textures;
        this.texturesOverlay = texturesOverlay;
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
    }

    public ResourceLocation getTextureLocation(E entity) {
        return this.getEntityTexture((EasyNPC)entity);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return this.defaultTexture;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return this.textures == null ? Constants.BLANK_ENTITY_TEXTURE : this.textures.getOrDefault(variant, this.defaultTexture);
    }

    @Override
    public ResourceLocation getTextureOverlayByVariant(Enum<?> variant) {
        return this.texturesOverlay == null ? Constants.BLANK_ENTITY_TEXTURE : this.texturesOverlay.getOrDefault(variant, Constants.BLANK_ENTITY_TEXTURE);
    }

    protected void scale(E entity, PoseStack poseStack, float unused) {
        EasyNPCModelRenderer.scaleEntity(entity, poseStack);
    }

    protected void renderNameTag(E entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int color) {
        EasyNPCModelRenderer.renderEntityNameTag(entity, poseStack);
        super.m_7649_(entity, component, poseStack, multiBufferSource, color);
    }

    protected int getBlockLightLevel(E entity, BlockPos blockPos) {
        return EasyNPCModelRenderer.getEntityLightLevel(entity, blockPos);
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.renderModel((EasyNPCBaseModelEntity)entity, this.m_7200_(), entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (!EasyNPCRenderer.renderEntity(entity, entityYaw, partialTicks, poseStack, buffer, packedLight)) {
            super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }
}

