/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.client.model.custom.OrcModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Orc;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class OrcModelRenderer
extends BaseHumanoidMobModelRenderer<Orc, Orc.Variant, OrcModel<Orc>> {
    protected static final Map<Orc.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Orc.Variant.class), map -> {
        map.put(Orc.Variant.DEFAULT, new ResourceLocation("easy_npc", "textures/entity/orc/orc_default.png"));
        map.put(Orc.Variant.WARRIOR, new ResourceLocation("easy_npc", "textures/entity/orc/orc_warrior.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Orc.Variant.DEFAULT);

    public OrcModelRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new OrcModel(context.m_174023_(modelLayerLocation)), 0.3f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
    }

    @Override
    public void renderDefaultPose(Orc entity, OrcModel<Orc> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-0.5, 0.0, 0.0);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                model.m_5585_().f_104203_ = -0.7853982f;
                model.m_5585_().f_104204_ = -0.7853982f;
                model.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(0.5, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-35.0f));
                break;
            }
            default: {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                model.m_5585_().f_104203_ = 0.0f;
                model.m_5585_().f_104204_ = 0.0f;
                model.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

