/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.client.model.standard.StandardPlayerModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseLivingEntityModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.HumanoidSlim;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class HumanoidSlimModelRenderer
extends BaseLivingEntityModelRenderer<HumanoidSlim, HumanoidSlim.Variant, StandardPlayerModel<HumanoidSlim>> {
    protected static final Map<HumanoidSlim.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(HumanoidSlim.Variant.class), map -> {
        map.put(HumanoidSlim.Variant.ALEX, new ResourceLocation("textures/entity/alex.png"));
        map.put(HumanoidSlim.Variant.KAWORRU, new ResourceLocation("easy_npc", "textures/entity/humanoid_slim/kaworru.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)HumanoidSlim.Variant.ALEX);

    public <L extends RenderLayer<HumanoidSlim, StandardPlayerModel<HumanoidSlim>>> HumanoidSlimModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new StandardPlayerModel(context.m_174023_(ModelLayers.f_171166_), true), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.m_115326_((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.f_171167_, ModelLayers.f_171168_, humanoidArmorLayerClass));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
    }

    @Override
    public ResourceLocation getTextureLocation(HumanoidSlim entity) {
        return this.getEntityPlayerTexture(entity);
    }

    @Override
    public void renderDefaultPose(HumanoidSlim entity, StandardPlayerModel<HumanoidSlim> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-1.0, 0.0, 0.0);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                model.m_5585_().f_104203_ = -0.7853982f;
                model.m_5585_().f_104204_ = -0.7853982f;
                model.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-35.0f));
                break;
            }
            default: {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                model.m_5585_().f_104203_ = 0.0f;
                model.m_5585_().f_104204_ = 0.0f;
                model.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

