/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SliderButton
extends AbstractSliderButton {
    public static final int DEFAULT_HEIGHT = 16;
    protected static final Component EMPTY_TEXT = new TextComponent("");
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final OnChange onChange;
    protected final float maxValue;
    private final float minValue;
    private final float stepSize;
    private final float valueFraction;
    private final Type type;
    private float initValue;
    private float targetValue;
    private float roundFactor = 100.0f;

    public SliderButton(int x, int y, int width, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, 16, (Component)new TextComponent(name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, EMPTY_TEXT, initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, (Component)new TextComponent(name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, double initValue, double minValue, double maxValue, OnChange onChange) {
        this(x, y, width, height, (Component)new TextComponent(name), (float)initValue, (float)minValue, (float)maxValue, onChange, Type.DOUBLE);
    }

    public SliderButton(int x, int y, int width, int height, Component name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        super(x, y, width, height, name, (double)initValue);
        this.initValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = SliderButton.getStepSize(type);
        this.valueFraction = maxValue - minValue;
        this.f_93577_ = (this.initValue - minValue) / this.valueFraction;
        if (this.minValue == 0.0f && this.maxValue == 360.0f || this.minValue == -180.0f && this.maxValue == 180.0f) {
            this.roundFactor = 1.0f;
        }
        this.onChange = onChange;
        this.type = type;
        this.updateTargetValue();
        this.m_5695_();
    }

    private static float getMinValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> -180.0f;
            case Type.DOUBLE -> 0.0f;
            case Type.SCALE -> 0.1f;
            case Type.POSITION -> -24.0f;
            default -> -100.0f;
        };
    }

    private static float getMaxValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> 180.0f;
            case Type.DOUBLE -> 1024.0f;
            case Type.SCALE -> 10.0f;
            case Type.POSITION -> 24.0f;
            default -> 100.0f;
        };
    }

    private static float getStepSize(Type type) {
        return switch (type) {
            case Type.DEGREE -> 0.5f;
            case Type.DOUBLE -> 1.0f;
            case Type.SCALE -> 0.1f;
            case Type.POSITION -> 0.1f;
            default -> 1.0f;
        };
    }

    public void setDefaultValue(double value) {
        this.setDefaultValue((float)Math.round(value * (double)this.roundFactor) / this.roundFactor);
    }

    public void setDefaultValue(float value) {
        this.initValue = value;
        this.f_93577_ = (this.initValue - this.minValue) / this.valueFraction;
        this.m_5697_();
        this.m_5695_();
    }

    public void reset() {
        this.setDefaultValue(0.0f);
    }

    public void resetToDefault() {
        this.setDefaultValue(this.initValue);
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    private void setTargetValue(double value) {
        this.f_93577_ = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        this.m_5697_();
        this.m_5695_();
    }

    public double getTargetDoubleValue() {
        return this.targetValue;
    }

    private void updateTargetValue() {
        this.targetValue = (float)Math.round(((double)this.minValue + (double)this.valueFraction * this.f_93577_) * (double)this.roundFactor) / this.roundFactor;
    }

    private double getStepSize() {
        return this.stepSize / this.valueFraction;
    }

    protected void m_5695_() {
        switch (this.type) {
            case DEGREE: {
                this.m_93666_((Component)new TextComponent(this.targetValue + "\u00b0"));
                break;
            }
            default: {
                this.m_93666_((Component)new TextComponent("" + this.targetValue));
            }
        }
    }

    protected void m_5697_() {
        this.updateTargetValue();
        this.onChange.onChange(this);
    }

    protected void m_7906_(@NotNull PoseStack poseStack, @NotNull Minecraft minecraft, int left, int top) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.m_198029_() ? 2 : 1) * 20;
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.f_93621_, 0, 46 + i, 4, this.f_93619_);
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)) + 4, this.f_93621_, 196, 46 + i, 4, this.f_93619_);
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.f_93621_ + this.f_93619_ - 4, 0, 46 + i + 20 - 4, 4, 4);
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)) + 4, this.f_93621_ + this.f_93619_ - 4, 196, 46 + i + 20 - 4, 4, 4);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 || keyCode == 262) {
            float step = keyCode == 263 ? -1.0f : 1.0f;
            double incrementalSteps = (double)step * this.getStepSize();
            this.setTargetValue(this.f_93577_ + incrementalSteps);
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double distance) {
        if (this.m_198029_()) {
            double incrementalSteps = distance * this.getStepSize();
            this.setTargetValue(this.f_93577_ + incrementalSteps);
        }
        return true;
    }

    public void m_6303_(PoseStack poseStack, int left, int top, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.m_7202_(this.m_198029_());
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_93228_(poseStack, this.f_93620_ + this.f_93618_ / 2, this.f_93621_, 200 - this.f_93618_ / 2, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_ + this.f_93619_ - 4, 0, 46 + i * 20 + 20 - 4, this.f_93618_ / 2, 4);
        this.m_93228_(poseStack, this.f_93620_ + this.f_93618_ / 2, this.f_93621_ + this.f_93619_ - 4, 200 - this.f_93618_ / 2, 46 + i * 20 + 20 - 4, this.f_93618_ / 2, 4);
        this.m_7906_(poseStack, minecraft, left, top);
        int fgColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        SliderButton.m_93215_((PoseStack)poseStack, (Font)font, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(fgColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }

    public static enum Type {
        DOUBLE,
        DEGREE,
        POSITION,
        SCALE,
        UNKNOWN;

    }

    public static interface OnChange {
        public void onChange(SliderButton var1);
    }
}

