/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SpriteButton
extends CustomButton {
    public static final int DEFAULT_HEIGHT = 16;
    public static final ResourceLocation DEFAULT_SPRITE = Constants.TEXTURE_CONFIGURATION;
    private final ResourceLocation sprite;
    private final int spriteX;
    private final int spriteY;
    private final int spriteOffsetX;
    private final int spriteOffsetY;
    private final int spriteWidth;
    private final int spriteHeight;
    private boolean renderBackground = true;

    public SpriteButton(int left, int top, int width, ResourceLocation sprite, int spriteOffsetX, int spriteOffsetY, Button.OnPress onPress) {
        this(left, top, width, sprite, 0, 0, spriteOffsetX, spriteOffsetY, 16, 16, onPress);
    }

    public SpriteButton(int left, int top, int width, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, 16, DEFAULT_SPRITE, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, 16, sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)new TextComponent(""), sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)new TextComponent(""), DEFAULT_SPRITE, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, ResourceLocation sprite, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, "", sprite, 0, 0, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, String label, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)(label != null && !label.isBlank() && Character.isLowerCase(label.codePointAt(0)) ? new TranslatableComponent("text.easy_npc.config." + label) : new TextComponent(label != null ? label : "")), DEFAULT_SPRITE, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, String label, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)(label != null && !label.isBlank() && Character.isLowerCase(label.codePointAt(0)) ? new TranslatableComponent("text.easy_npc.config." + label) : new TextComponent(label != null ? label : "")), sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, Component text, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        super(left, top, width, height, (Component)(text != null ? text : new TextComponent("")), onPress);
        this.sprite = sprite;
        this.spriteX = spriteX;
        this.spriteY = spriteY;
        this.spriteOffsetX = spriteOffsetX;
        this.spriteOffsetY = spriteOffsetY;
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
    }

    @Override
    public void renderButtonText(PoseStack poseStack, Font font, Component component, int x, int y) {
        if (component != null && !component.getString().isEmpty()) {
            int fgColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
            SpriteButton.m_93215_((PoseStack)poseStack, (Font)font, (Component)component, (int)(this.f_93620_ + (this.f_93618_ + this.spriteWidth) / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(fgColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    @Override
    public void m_6303_(PoseStack poseStack, int left, int top, float partialTicks) {
        if (this.renderBackground) {
            super.m_6303_(poseStack, left, top, partialTicks);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.sprite);
        this.m_93228_(poseStack, this.f_93620_ + this.spriteX, this.f_93621_ + this.spriteY, this.spriteOffsetX, this.m_142518_() ? this.spriteOffsetY : this.spriteOffsetY + this.spriteHeight, this.spriteWidth, this.spriteHeight);
    }
}

