/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.config.CommonConfig;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurationScreen<T extends ConfigurationMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final EasyNPC<?> easyNPC;
    protected final SkinModel skinModel;
    protected final UUID uuid;
    protected final LivingEntity owner;
    protected final String ownerName;
    protected final boolean hasOwner;
    protected final boolean supportsPoseConfiguration;
    protected final boolean supportsStandardPoseConfiguration;
    protected final boolean supportsAdvancedPoseConfiguration;
    protected final boolean supportsCustomPoseConfiguration;
    protected final boolean supportsScalingConfiguration;
    protected final boolean supportsSkinConfiguration;
    protected final boolean supportsNoneSkinConfiguration;
    protected final boolean supportsDefaultSkinConfiguration;
    protected final boolean supportsUrlSkinConfiguration;
    protected final boolean supportsPlayerSkinConfiguration;
    protected final boolean supportsCustomSkinConfiguration;
    protected Button closeButton = null;
    protected Button homeButton = null;
    protected float xMouse;
    protected float yMouse;
    protected int bottomPos;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;
    protected int rightPos;

    public ConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.easyNPC = ((ConfigurationMenu)((Object)menu)).getEasyNPC();
        this.skinModel = this.easyNPC.getEasyNPCSkinData().getSkinModel();
        this.uuid = this.easyNPC.getUUID();
        OwnerData<?> ownerData = this.easyNPC.getEasyNPCOwnerData();
        this.hasOwner = ownerData.hasOwner();
        this.owner = this.hasOwner ? ownerData.getOwner() : null;
        this.ownerName = this.hasOwner ? ownerData.getOwnerName() : "";
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance.f_91074_;
        this.clientLevel = this.minecraftInstance.f_91073_;
        ConfigurationData<?> configurationData = this.easyNPC.getEasyNPCConfigurationData();
        this.supportsPoseConfiguration = configurationData.supportsPoseConfiguration();
        this.supportsStandardPoseConfiguration = configurationData.supportsStandardPoseConfiguration();
        this.supportsAdvancedPoseConfiguration = configurationData.supportsAdvancedPoseConfiguration();
        this.supportsCustomPoseConfiguration = configurationData.supportsCustomPoseConfiguration();
        this.supportsScalingConfiguration = configurationData.supportsScalingConfiguration();
        this.supportsSkinConfiguration = configurationData.supportsSkinConfiguration();
        this.supportsNoneSkinConfiguration = configurationData.supportsNoneSkinConfiguration();
        this.supportsCustomSkinConfiguration = configurationData.supportsCustomSkinConfiguration();
        this.supportsDefaultSkinConfiguration = configurationData.supportsDefaultSkinConfiguration();
        this.supportsPlayerSkinConfiguration = configurationData.supportsPlayerSkinConfiguration();
        this.supportsUrlSkinConfiguration = configurationData.supportsUrlSkinConfiguration();
    }

    protected static Double getDoubleValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse double value: {}", (Object)value);
            }
        }
        return null;
    }

    protected static boolean isFloatValue(String text) {
        return text != null && (text.isEmpty() || text.matches("^\\d+(\\.?\\d*)?$") && Float.parseFloat(text) >= 0.0f);
    }

    protected static boolean isPositiveNumericValue(String text) {
        return text != null && (text.isEmpty() || text.matches("^\\d+$") && Integer.parseInt(text) > 0);
    }

    protected static boolean isNumericValue(String text) {
        return text != null && (text.isEmpty() || text.matches("^\\d+$") && Integer.parseInt(text) >= 0);
    }

    protected SkinModel getSkinModel() {
        return this.skinModel;
    }

    public void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
    }

    public void showMainScreen() {
        ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.MAIN);
    }

    protected boolean hasPermissions(Boolean enabled, Boolean allowInCreative, int permissionLevel) {
        if (Boolean.FALSE.equals(enabled)) {
            return false;
        }
        if (Boolean.TRUE.equals(allowInCreative != false && this.localPlayer != null) && this.localPlayer.m_7500_()) {
            return true;
        }
        return this.localPlayer != null && this.localPlayer.m_20310_(permissionLevel);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 318;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        this.buttonLeftPos = this.f_97735_ + 17;
        this.buttonTopPos = this.f_97736_ + 17;
        this.contentLeftPos = this.f_97735_ + 7;
        this.contentTopPos = this.f_97736_ + 43;
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(true);
        }
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.f_97735_ + 7, this.buttonTopPos, 10, "<", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.MAIN)));
    }

    public void m_7861_() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
        super.m_7861_();
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        Text.drawString(poseStack, this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_, 132, 0, 120, 160);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_ + 77, 132, 5, 120, 170);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

