/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.menu.configuration.dialog.AdvancedDialogConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedDialogConfigurationScreen
extends DialogConfigurationScreen<AdvancedDialogConfigurationMenu> {
    Button newDialogButton;
    DialogList dialogList;

    public AdvancedDialogConfigurationScreen(AdvancedDialogConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedDialogButton.f_93623_ = false;
        this.dialogList = new DialogList();
        this.m_7787_((GuiEventListener)this.dialogList);
        this.newDialogButton = (Button)this.m_142416_((GuiEventListener)new AddButton(this.contentLeftPos, this.contentTopPos + 168, 200, "dialog.add", onPress -> ServerNetworkMessageHandler.openDialogEditor(this.uuid, ConfigurationType.ADVANCED_DIALOG)));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 5), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 314), (int)(this.f_97736_ + 230), (int)-1118482);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 109), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 110), (int)(this.f_97736_ + 210), (int)-4473925);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 198), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 199), (int)(this.f_97736_ + 210), (int)-4473925);
        this.dialogList.m_6305_(poseStack, x, y, partialTicks);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 5), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 314), (int)(this.f_97736_ + 59), (int)-5592406);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 5), (int)(this.f_97736_ + 210), (int)(this.f_97735_ + 314), (int)(this.f_97736_ + 230), (int)-5592406);
        int headerLeft = this.f_97735_ + 10;
        Text.drawConfigString(poseStack, this.f_96547_, "label_id", headerLeft, this.f_97736_ + 45, 0);
        Text.drawString(poseStack, this.f_96547_, "Name", headerLeft + 103, this.f_97736_ + 45, 0);
        Text.drawString(poseStack, this.f_96547_, "Text", headerLeft + 191, this.f_97736_ + 45, 0);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 109), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 110), (int)(this.f_97736_ + 59), (int)-10066330);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 198), (int)(this.f_97736_ + 40), (int)(this.f_97735_ + 199), (int)(this.f_97736_ + 59), (int)-10066330);
        this.newDialogButton.m_6305_(poseStack, x, y, partialTicks);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    @OnlyIn(value=Dist.CLIENT)
    class DialogList
    extends ObjectSelectionList<Entry> {
        DialogList() {
            super(AdvancedDialogConfigurationScreen.this.f_96541_, AdvancedDialogConfigurationScreen.this.f_96543_ + 50, AdvancedDialogConfigurationScreen.this.f_96544_ - 60, AdvancedDialogConfigurationScreen.this.f_97736_ + 56, AdvancedDialogConfigurationScreen.this.f_97736_ + 211, 19);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            for (DialogDataEntry dialogData : AdvancedDialogConfigurationScreen.this.dialogDataSet.getDialogsByLabel()) {
                if (dialogData == null || dialogData.getId() == null) continue;
                this.m_7085_((AbstractSelectionList.Entry)new Entry(dialogData));
            }
        }

        public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_6305_(poseStack, x, y, partialTicks);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final DialogDataEntry dialogData;
            final EditButton editButton;
            final CopyButton copyLabelButton;
            final TextEditButton textEditButton;
            final String defaultDialogLabel;

            public Entry(DialogDataEntry dialogData) {
                this.dialogData = dialogData;
                this.editButton = new EditButton(0, 0, onPress -> ServerNetworkMessageHandler.openDialogEditor(AdvancedDialogConfigurationScreen.this.uuid, this.dialogData.getId(), ConfigurationType.ADVANCED_DIALOG));
                this.copyLabelButton = new CopyButton(0, 0, onPress -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91068_.m_90911_(dialogData.getLabel());
                });
                this.textEditButton = new TextEditButton(0, 0, onPress -> ServerNetworkMessageHandler.openDialogTextEditor(AdvancedDialogConfigurationScreen.this.uuid, this.dialogData.getId(), ConfigurationType.ADVANCED_DIALOG));
                this.defaultDialogLabel = AdvancedDialogConfigurationScreen.this.dialogDataSet.getDefaultDialogLabel();
            }

            public Component m_142172_() {
                return new TranslatableComponent(this.dialogData.getName());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                super.m_6375_(mouseX, mouseY, button);
                this.copyLabelButton.m_6375_(mouseX, mouseY, button);
                this.editButton.m_6375_(mouseX, mouseY, button);
                this.textEditButton.m_6375_(mouseX, mouseY, button);
                return button == 0;
            }

            public void m_6311_(PoseStack poseStack, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
                int leftPos = left - 75;
                this.editButton.f_93620_ = leftPos + 75;
                this.editButton.f_93621_ = top;
                this.editButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.editButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)new TranslatableComponent("text.easy_npc.config.dialog.edit_dialog", new Object[]{this.dialogData.getName()}), mouseX, mouseY);
                }
                this.copyLabelButton.f_93620_ = this.editButton.f_93620_ + this.editButton.m_5711_();
                this.copyLabelButton.f_93621_ = top;
                this.copyLabelButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.copyLabelButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)new TranslatableComponent("text.easy_npc.config.dialog.copy_dialog_label", new Object[]{this.dialogData.getLabel()}), mouseX, mouseY);
                }
                this.textEditButton.f_93620_ = leftPos + 200;
                this.textEditButton.f_93621_ = top;
                this.textEditButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.textEditButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)new TranslatableComponent("text.easy_npc.config.dialog.edit_dialog_text", new Object[]{this.dialogData.getText()}), mouseX, mouseY);
                }
                float dialogDataScale = 0.75f;
                int dialogDataTopPos = Math.round((float)(top + 5) / dialogDataScale);
                int fontColor = this.dialogData.getLabel().equals(this.defaultDialogLabel) ? 43520 : 0;
                poseStack.m_85836_();
                poseStack.m_85841_(dialogDataScale, dialogDataScale, dialogDataScale);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getLabel(16), Math.round((float)(leftPos + 7) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getName(21), Math.round((float)(leftPos + 112) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getText(25), Math.round((float)(leftPos + 220) / dialogDataScale), dialogDataTopPos, fontColor);
                poseStack.m_85849_();
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(AdvancedDialogConfigurationScreen.this.f_97735_ + 5), (int)(top + 17), (int)(AdvancedDialogConfigurationScreen.this.f_97735_ + 314), (int)(top + 18), (int)-5592406);
            }
        }
    }
}

