/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.configuration.dialog.BasicDialogConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasicDialogConfigurationScreen
extends DialogConfigurationScreen<BasicDialogConfigurationMenu> {
    protected EditBox dialogBox;
    protected Button saveButton = null;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();
    private String dialogValue = "";

    public BasicDialogConfigurationScreen(BasicDialogConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicDialogButton.f_93623_ = false;
        this.dialogValue = this.dialogDataSet.hasDialog() && this.dialogDataSet.getType() == DialogType.BASIC ? this.dialogDataSet.getDefaultDialog().getText() : "";
        this.dialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.f_97736_ + 60, 300);
        this.dialogBox.m_94199_(512);
        this.dialogBox.m_94144_(this.dialogValue);
        this.m_142416_((GuiEventListener)this.dialogBox);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.contentLeftPos + 26, this.bottomPos - 40, "save", onPress -> {
            DialogDataSet dialogDataSet = DialogUtils.getBasicDialog(this.dialogBox.m_94155_());
            ServerNetworkMessageHandler.saveDialog(this.uuid, dialogDataSet);
            this.dialogValue = this.dialogBox.m_94155_();
        }));
        this.m_142416_((GuiEventListener)new CancelButton(this.rightPos - 130, this.bottomPos - 40, "cancel", onPress -> this.showMainScreen()));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("text.easy_npc.config.dialog_placeholder"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        Text.drawConfigString(poseStack, this.f_96547_, "dialog_text", this.contentLeftPos, this.f_97736_ + 50);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(poseStack, this.f_96547_, formattedCharSequence, this.f_97735_ + 15, this.f_97736_ + 100 + line * (9 + 2));
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = !this.dialogBox.m_94155_().equals(this.dialogValue);
        }
    }
}

