/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.equipment;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentConfigurationScreen
extends ConfigurationScreen<EquipmentConfigurationMenu> {
    protected final ModelData<?> modelData;
    protected Button defaultEquipmentButton;

    public EquipmentConfigurationScreen(EquipmentConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.modelData = this.easyNPC.getEasyNPCModelData();
    }

    private void createVisibleEquipmentSlotCheckbox(int left, int top, EquipmentSlot equipmentSlot) {
        boolean modelEquipmentVisibility = this.modelData.isModelEquipmentVisible(equipmentSlot);
        this.m_142416_((GuiEventListener)new Checkbox(left, top, "", modelEquipmentVisibility, checkbox -> ServerNetworkMessageHandler.modelVisibilityChange(this.uuid, equipmentSlot, checkbox.selected())));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        this.defaultEquipmentButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "equipment", button -> {}));
        this.defaultEquipmentButton.f_93623_ = false;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
        if (this.modelData.canUseArmor()) {
            int equipmentSlotLeft = this.contentLeftPos + 75;
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 2, EquipmentSlot.HEAD);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 20, EquipmentSlot.CHEST);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 38, EquipmentSlot.LEGS);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 55, EquipmentSlot.FEET);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        ScreenHelper.renderScaledEntityAvatar(this.contentLeftPos + 138, this.contentTopPos + 82, 35, (float)(this.contentLeftPos + 140) - this.xMouse, (float)(this.contentTopPos + 30) - this.yMouse, this.easyNPC.getLivingEntity());
        this.m_7025_(poseStack, x, y);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        if (this.modelData == null || this.modelData.canUseArmor()) {
            this.m_93228_(poseStack, this.contentLeftPos + 90, this.contentTopPos, 7, 7, 18, 72);
        }
        if (this.modelData == null || this.modelData.canUseMainHand()) {
            this.m_93228_(poseStack, this.contentLeftPos + 90, this.contentTopPos + 75, 7, 7, 18, 18);
        }
        if (this.modelData == null || this.modelData.canUseOffHand()) {
            this.m_93228_(poseStack, this.contentLeftPos + 170, this.contentTopPos + 75, 7, 7, 18, 18);
        }
        this.m_93228_(poseStack, this.contentLeftPos + 58, this.contentTopPos + 105, 7, 83, 162, 54);
        this.m_93228_(poseStack, this.contentLeftPos + 58, this.contentTopPos + 165, 7, 141, 162, 18);
        EquipmentConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 109), (int)(this.contentTopPos - 8), (int)(this.contentLeftPos + 169), (int)(this.contentTopPos + 102), (int)-16777216);
        EquipmentConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 110), (int)(this.contentTopPos - 7), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 101), (int)-5592406);
    }
}

