/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.main;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.ColorButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.main.MainConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MainConfigurationScreen
extends ConfigurationScreen<MainConfigurationMenu> {
    public static final int BUTTON_WIDTH = 90;
    public static final int BUTTON_HEIGHT = 18;
    private ColorButton nameColorButton;
    private Button saveNameButton;
    private EditBox nameBox;
    private int textColor = 0xFFFFFF;
    private String formerName = "";
    private int formerTextColor = 0xFFFFFF;

    public MainConfigurationScreen(MainConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void saveName() {
        String value = this.nameBox.m_94155_();
        if (value != null && !value.isBlank()) {
            if (this.nameColorButton != null) {
                this.textColor = this.nameColorButton.getColorValue();
            }
            log.debug("Saving name {} with color {} for {}", (Object)value, (Object)this.textColor, (Object)this.easyNPC);
            ServerNetworkMessageHandler.nameChange(this.uuid, value, this.textColor);
            this.formerName = value;
            this.formerTextColor = this.textColor;
            this.saveNameButton.f_93623_ = false;
        }
    }

    private void deleteNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                ServerNetworkMessageHandler.removeNPC(this.uuid);
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteQuestion"), (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteWarning", new Object[]{this.easyNPC.getEntity().m_5446_().getString()}), (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteButton"), CommonComponents.f_130656_));
    }

    private void respawnNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                ServerNetworkMessageHandler.respawnNPC(this.uuid);
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)new TranslatableComponent("text.easy_npc.respawnNPC.confirmQuestion"), (Component)new TranslatableComponent("text.easy_npc.respawnNPC.confirmWarning", new Object[]{this.easyNPC.getEntity().m_5446_().getString()}), (Component)new TranslatableComponent("text.easy_npc.respawnNPC.respawnButton"), CommonComponents.f_130656_));
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        int textColorValue = this.nameColorButton.getColorValue();
        this.saveNameButton.f_93623_ = nameValue != null && (!this.formerName.equals(nameValue) || this.formerTextColor != textColorValue);
    }

    @Override
    public void m_7856_() {
        if (this.easyNPC == null) {
            return;
        }
        super.m_7856_();
        int buttonLeftPosition = this.f_97735_ + 125;
        int buttonSpace = 4;
        int buttonTopPosition = this.f_97736_ + 50;
        this.homeButton.f_93624_ = false;
        RenderData renderData = this.easyNPC.getEasyNPCRenderData();
        RenderType renderType = renderData != null && renderData.getRenderData() != null ? renderData.getRenderData().getRenderType() : RenderType.DEFAULT;
        this.formerName = this.easyNPC.getEntity().m_7755_().getString();
        this.nameBox = new TextField(this.f_96547_, this.contentLeftPos + 1, this.f_97736_ + 25, 108);
        this.nameBox.m_94199_(32);
        this.nameBox.m_94144_(this.formerName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.nameColorButton = (ColorButton)this.m_142416_((GuiEventListener)new ColorButton(this.f_97735_ + 119, this.f_97736_ + 24, onPress -> this.validateName()));
        if (this.easyNPC.getEntity().m_8077_() && this.easyNPC.getEntity().m_7770_().m_7383_() != null && this.easyNPC.getEntity().m_7770_().m_7383_().m_131135_() != null) {
            int styleTextColor = this.easyNPC.getEntity().m_7770_().m_7383_().m_131135_().m_131265_();
            for (DyeColor dyeColor : DyeColor.values()) {
                if (dyeColor.m_41071_() != styleTextColor) continue;
                this.nameColorButton.setColor(dyeColor);
                this.formerTextColor = styleTextColor;
                break;
            }
        }
        this.saveNameButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.f_97735_ + 139, this.f_97736_ + 24, onPress -> this.saveName()));
        this.saveNameButton.f_93623_ = false;
        SkinData skinData = this.easyNPC.getEasyNPCSkinData();
        Button editSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.f_97736_ + 195, 110, "edit_skin", onPress -> {
            SkinType skinType = skinData.getSkinType();
            switch (skinType) {
                case NONE: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.NONE_SKIN);
                    break;
                }
                case PLAYER_SKIN: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.URL_SKIN);
                    break;
                }
                case CUSTOM: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        editSkinButton.f_93623_ = renderType == RenderType.DEFAULT && this.supportsSkinConfiguration && (this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.noneSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.noneSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.noneSkinConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultSkinConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.playerSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.playerSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.playerSkinConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.customSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.customSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.customSkinConfigurationPermissionLevel.get()));
        Button importButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "import", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_PRESET_IMPORT)));
        importButton.f_93623_ = true;
        Button exportButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition + importButton.m_5711_() + buttonSpace, buttonTopPosition, 90, "export", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_PRESET_EXPORT)));
        exportButton.f_93623_ = true;
        buttonTopPosition = buttonTopPosition + 18 + buttonSpace;
        Button editDialogButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "dialog", onPress -> {
            switch (((MainConfigurationMenu)this.f_97732_).getDialogType()) {
                case NONE: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.NONE_DIALOG);
                    break;
                }
                case YES_NO: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
                    break;
                }
                case CUSTOM: 
                case STANDARD: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_DIALOG);
                    break;
                }
                default: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.BASIC_DIALOG);
                }
            }
        }));
        editDialogButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicDialogConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.yesNoDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.yesNoDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.yesNoDialogConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.noneDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.noneDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.noneDialogConfigurationPermissionLevel.get());
        Button editActionButton = (Button)this.m_142416_((GuiEventListener)new TextButton(editDialogButton.f_93620_ + editDialogButton.m_5711_() + buttonSpace, buttonTopPosition, 90, "actions", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.BASIC_ACTION)));
        editActionButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicActionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicActionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicActionConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.dialogActionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.dialogActionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.dialogActionConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 18 + buttonSpace;
        Button editEquipmentButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "equipment", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.EQUIPMENT)));
        editEquipmentButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.equipmentConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.equipmentConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.equipmentConfigurationPermissionLevel.get());
        ScaleData scaleData = this.easyNPC.getEasyNPCScaleData();
        Button editScalingButton = (Button)this.m_142416_((GuiEventListener)new TextButton(editEquipmentButton.f_93620_ + editEquipmentButton.m_5711_() + buttonSpace, buttonTopPosition, 90, "scaling", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.SCALING)));
        editScalingButton.f_93623_ = renderType == RenderType.DEFAULT && scaleData != null && this.supportsScalingConfiguration && this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.scalingConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.scalingConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.scalingConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 18 + buttonSpace;
        ModelData modelData = this.easyNPC.getEasyNPCModelData();
        Button editPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "pose", onPress -> {
            ModelPose modelPose = modelData.getModelPose();
            switch (modelPose) {
                case CUSTOM: {
                    if (modelData.hasChangedModelPosition()) {
                        ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_POSE);
                        break;
                    }
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_POSE);
                    break;
                }
                default: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSE);
                }
            }
        }));
        editPoseButton.f_93623_ = renderType == RenderType.DEFAULT && modelData != null && this.supportsPoseConfiguration && (this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultPoseConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultPoseConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultPoseConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.customPoseConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.customPoseConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.customPoseConfigurationPermissionLevel.get()));
        Button editPositionButton = (Button)this.m_142416_((GuiEventListener)new TextButton(editPoseButton.f_93620_ + editPoseButton.m_5711_() + buttonSpace, buttonTopPosition, 90, "position", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSITION)));
        editPositionButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultPositionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultPositionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultPositionConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 18 + buttonSpace;
        Button editRotationButton = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "rotation", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_ROTATION)));
        editRotationButton.f_93623_ = renderType == RenderType.DEFAULT && modelData != null && this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultRotationConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultRotationConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultRotationConfigurationPermissionLevel.get());
        TradingData tradingData = this.easyNPC.getEasyNPCTradingData();
        Button editTradesButton = (Button)this.m_142416_((GuiEventListener)new TextButton(editRotationButton.f_93620_ + editRotationButton.m_5711_() + buttonSpace, buttonTopPosition, 90, "trading", onPress -> {
            TradingType tradingType = tradingData.getTradingType();
            switch (tradingType) {
                case BASIC: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.BASIC_TRADING);
                    break;
                }
                case ADVANCED: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_TRADING);
                    break;
                }
                case CUSTOM: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_TRADING);
                    break;
                }
                default: {
                    ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.NONE_TRADING);
                }
            }
        }));
        editTradesButton.f_93623_ = tradingData != null && this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicTradingConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicTradingConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicTradingConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.advancedTradingConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.advancedTradingConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.advancedTradingConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.customTradingConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.customTradingConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.customTradingConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 18 + buttonSpace;
        Button editAttributes = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPosition, buttonTopPosition, 90, "attributes", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ABILITIES_ATTRIBUTE)));
        editAttributes.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.abilitiesAttributeConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.abilitiesAttributeConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.abilitiesAttributeConfigurationPermissionLevel.get());
        Button editObjectiveButton = (Button)this.m_142416_((GuiEventListener)new TextButton(editAttributes.f_93620_ + editAttributes.m_5711_() + buttonSpace, buttonTopPosition, 90, "objective", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.BASIC_OBJECTIVE)));
        editObjectiveButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicObjectiveConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicObjectiveConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicObjectiveConfigurationPermissionLevel.get());
        Button copyUUIDButton = (Button)this.m_142416_((GuiEventListener)new CopyButton(this.contentLeftPos, this.bottomPos - 27, 90, "copy_uuid", onPress -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && minecraft.f_91068_ != null) {
                minecraft.f_91068_.m_90911_(this.uuid.toString());
            }
        }));
        copyUUIDButton.f_93623_ = true;
        Button respawnButton = (Button)this.m_142416_((GuiEventListener)new TextButton(copyUUIDButton.f_93620_ + copyUUIDButton.m_5711_() + buttonSpace, this.bottomPos - 27, 70, "respawn", onPress -> this.respawnNPC()));
        respawnButton.f_93623_ = true;
        Button removeEntityButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.rightPos - 70, this.bottomPos - 29, 65, onPress -> this.deleteNPC()));
        removeEntityButton.setFGColor(0xFF5555);
        removeEntityButton.f_93623_ = true;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        BlockPos blockPos;
        NavigationData navigationData;
        super.m_6305_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
        ScreenHelper.renderScaledEntityAvatar(this.f_97735_ + 60, this.f_97736_ + 185, (float)(this.f_97735_ + 50) - this.xMouse, (float)(this.f_97736_ + 90) - this.yMouse, this.easyNPC);
        float scaleEntityTypeText = 0.75f;
        poseStack.m_85836_();
        poseStack.m_85841_(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        Text.drawString(poseStack, this.f_96547_, this.easyNPC.getEntity().m_6095_().m_20676_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.f_97736_ + 49) / scaleEntityTypeText));
        poseStack.m_85837_(0.0, 0.0, 100.0);
        if (this.uuid != null) {
            Text.drawString(poseStack, this.f_96547_, "UUID: " + this.uuid, Math.round((float)(this.contentLeftPos + 1) / scaleEntityTypeText), Math.round((float)(this.f_97736_ + 15) / scaleEntityTypeText));
        }
        if (this.hasOwner) {
            Text.drawString(poseStack, this.f_96547_, "Owner: " + this.ownerName, Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.f_97736_ + 61) / scaleEntityTypeText));
        }
        if ((navigationData = this.easyNPC.getEasyNPCNavigationData()).hasHomePosition()) {
            blockPos = navigationData.getHomePosition();
            Text.drawString(poseStack, this.f_96547_, "Home: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.f_97736_ + 70) / scaleEntityTypeText));
        }
        blockPos = this.easyNPC.getEntity().m_20097_();
        Text.drawString(poseStack, this.f_96547_, "Pos: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.f_97736_ + 187) / scaleEntityTypeText));
        poseStack.m_85849_();
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int x, int y) {
        Text.drawString(poseStack, this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ - 1, 0x404040);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int avatarTopPos = this.f_97736_ + 45;
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)avatarTopPos, (int)(this.f_97735_ + 117), (int)(avatarTopPos + 135), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(avatarTopPos + 1), (int)(this.f_97735_ + 116), (int)(avatarTopPos + 134), (int)-1);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(avatarTopPos + 13), (int)(this.f_97735_ + 117), (int)(avatarTopPos + 155), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(avatarTopPos + 14), (int)(this.f_97735_ + 116), (int)(avatarTopPos + 154), (int)-5592406);
    }
}

