/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.pose.CustomPoseConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomPoseConfigurationScreen
extends PoseConfigurationScreen<CustomPoseConfigurationMenu> {
    protected SliderButton headSliderButton;
    protected SliderButton bodySliderButton;
    protected SliderButton armsSliderButton;
    protected SliderButton leftArmSliderButton;
    protected SliderButton rightArmSliderButton;
    protected SliderButton leftLegSliderButton;
    protected SliderButton rightLegSliderButton;

    public CustomPoseConfigurationScreen(CustomPoseConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private SliderButton createVisibilityRotationPositionSlider(int left, int top, ModelPart modelPart, String label) {
        SliderButton sliderRotationButtonX = this.createRotationSliderCompact(left, top, modelPart, label);
        SliderButton sliderPositionButtonX = this.createPositionSliderCompact(left, top + sliderRotationButtonX.m_93694_(), modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.m_142416_((GuiEventListener)new Checkbox(sliderRotationButtonX.f_93620_ + 3, top - sliderPositionButtonX.m_93694_(), "", modelPartVisibility, checkbox -> ServerNetworkMessageHandler.modelVisibilityChange(this.uuid, modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customPoseButton.f_93623_ = false;
        int sliderTopPos = this.contentTopPos + 16;
        int sliderLeftPos = this.contentLeftPos - 3;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 66;
        VariantData variantData = this.easyNPC.getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodySliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.armsSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        if (this.modelData.hasRightLegModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(this.contentLeftPos + 152, this.contentTopPos + 155, 45, (float)(this.contentLeftPos + 140) - this.xMouse, (float)(this.contentTopPos + 30) - this.yMouse, this.easyNPC);
        if (this.modelData.hasHeadModelPart() && this.headSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.head", this.headSliderButton.f_93620_ + 20, this.headSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodySliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.body", this.bodySliderButton.f_93620_ + 20, this.bodySliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.left_arm", this.leftArmSliderButton.f_93620_ + 20, this.leftArmSliderButton.f_93621_ - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.arms", this.armsSliderButton.f_93620_ + 20, this.armsSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.right_arm", this.rightArmSliderButton.f_93620_ + 20, this.rightArmSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.left_leg", this.leftLegSliderButton.f_93620_ + 20, this.leftLegSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.right_leg", this.rightLegSliderButton.f_93620_ + 20, this.rightLegSliderButton.f_93621_ - 12);
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        CustomPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 99), (int)this.contentTopPos, (int)(this.contentLeftPos + 206), (int)(this.contentTopPos + 188), (int)-16777216);
        CustomPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 100), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 205), (int)(this.contentTopPos + 187), (int)-5592406);
    }
}

