/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.skin.DefaultSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultSkinConfigurationScreen
extends SkinConfigurationScreen<DefaultSkinConfigurationMenu> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    protected final SkinData<?> skinData = this.easyNPC.getEasyNPCSkinData();
    protected final VariantData<?> variantData;
    protected final ProfessionData<?> professionData = this.easyNPC.getEasyNPCProfessionData();
    protected int numOfProfessions = 0;
    protected int numOfVariants = 0;
    private Profession[] professions;
    private Enum<?>[] variants;

    public DefaultSkinConfigurationScreen(DefaultSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.variantData = this.easyNPC.getEasyNPCVariantData();
        this.maxSkinsPerPage = 10;
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.easyNPC == null) {
            return;
        }
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int variantIndex = this.numOfProfessions > 0 ? i / this.numOfProfessions : i;
            Profession profession = this.numOfProfessions > 0 ? this.professions[i - variantIndex * this.numOfProfessions] : null;
            Enum<?> variant = this.variants[variantIndex];
            int left = this.f_97735_ + (skinPosition > 4 ? -268 : 32) + skinPosition * 60;
            int top = this.contentTopPos + 82 + (skinPosition > 4 ? 84 : 0);
            this.renderSkinEntity(poseStack, left, top, variant, profession);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 100.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(variant.name(), 14);
            Text.drawString(poseStack, this.f_96547_, variantName, leftNamePos, topNamePos, 43520);
            if (profession != null) {
                String professionName = TextUtils.normalizeString(profession.name(), 13);
                Text.drawString(poseStack, this.f_96547_, professionName, leftNamePos, topNamePos + 10, 0);
            }
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(PoseStack poseStack, int x, int y, Enum<?> variant, Profession profession) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            if (profession != null) {
                ServerNetworkMessageHandler.professionChange(this.uuid, profession);
            }
            ServerNetworkMessageHandler.setDefaultSkin(this.uuid, variant);
        });
        skinButton.f_93623_ = this.skinData.getSkinType() != SkinType.DEFAULT || !this.variantData.getVariant().equals(variant) || profession != null && !this.professionData.getProfession().equals((Object)profession);
        ScreenHelper.renderEntityDefaultSkin(x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.easyNPC, variant, profession);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultSkinButton.f_93623_ = false;
        this.professions = this.professionData.getProfessions();
        this.variants = this.variantData.getVariants();
        this.numOfProfessions = this.professionData.hasProfessions() ? this.professions.length : 0;
        this.numOfVariants = this.variants.length;
        this.numOfSkins = this.numOfProfessions > 0 ? this.numOfVariants * this.numOfProfessions : this.numOfVariants;
        log.debug("Found about {} skins with {} variants and {} professions.", (Object)this.numOfSkins, (Object)this.numOfVariants, (Object)this.numOfProfessions);
        int skinButtonTop = this.f_97736_ + 212;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.f_97735_ + 289;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6305_(poseStack, x, y, partialTicks);
            }
        }
        this.renderSkins(poseStack);
    }

    @Override
    protected void renderSkinSelectionBackground(PoseStack poseStack) {
        DefaultSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 302), (int)(this.contentTopPos + 170), (int)-16777216);
        DefaultSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 301), (int)(this.contentTopPos + 169), (int)-5592406);
    }
}

