/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.menu.configuration.skin.PlayerSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.validator.NameValidator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class PlayerSkinConfigurationScreen
extends SkinConfigurationScreen<PlayerSkinConfigurationMenu> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected final SkinData<?> skinData = this.easyNPC.getEasyNPCSkinData();
    protected Button addTextureSettingsButton = null;
    protected EditBox textureSkinLocationBox;
    protected int lastNumOfSkins = 0;
    private Button clearTextureSettingsButton = null;
    private String formerTextureSkinLocation = "";
    private boolean canTextureSkinLocationChange = true;

    public PlayerSkinConfigurationScreen(PlayerSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.easyNPC == null) {
            return;
        }
        int positionTop = 119;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        Set<UUID> textures = PlayerTextureManager.getTextureCacheKeys(this.skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.f_97735_ + 32 + skinPosition * 60;
            int top = this.f_97736_ + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(poseStack, left, top, this.skinModel, textureKey);
            int topNamePos = Math.round((float)(top - 76) / 0.7f);
            int leftNamePos = Math.round((float)(left - 21) / 0.7f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 100.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(poseStack, this.f_96547_, variantName, leftNamePos, topNamePos, 43520);
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(PoseStack poseStack, int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = PlayerTextureManager.getTextureSkinType(textureModelKey);
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> ServerNetworkMessageHandler.setPlayerSkin(this.uuid, "", textureUUID));
        UUID skinUUID = this.skinData.getSkinUUID();
        skinButton.f_93623_ = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityPlayerSkin(x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.easyNPC, textureUUID, skinType);
        this.skinButtons.add(skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.m_94155_().isEmpty()) {
            this.textureSkinLocationBox.m_94144_("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (!textureSkinLocationValue.equals(this.formerTextureSkinLocation) && (textureSkinLocationValue.isEmpty() || NameValidator.isValidPlayerName(textureSkinLocationValue))) {
            if (NameValidator.isValidPlayerName(textureSkinLocationValue)) {
                log.debug("Setting player user texture to {}", (Object)textureSkinLocationValue);
                TextureManager.clearLastErrorMessage();
                ServerNetworkMessageHandler.setPlayerSkin(this.uuid, textureSkinLocationValue, Constants.BLANK_UUID);
            }
            this.addTextureSettingsButton.f_93623_ = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            PlayerSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (!this.canTextureSkinLocationChange) {
            this.addTextureSettingsButton.f_93623_ = false;
            this.clearTextureSettingsButton.f_93623_ = true;
            return;
        }
        this.addTextureSettingsButton.f_93623_ = !textureSkinLocationValue.isEmpty() && NameValidator.isValidPlayerName(textureSkinLocationValue);
        this.clearTextureSettingsButton.f_93623_ = !textureSkinLocationValue.isEmpty();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.playerSkinButton.f_93623_ = false;
        TextureManager.clearLastErrorMessage();
        this.numOfSkins = PlayerTextureManager.getTextureCacheKeys(this.skinModel).size();
        this.textureSkinLocationBox = new TextField(this.f_96547_, this.contentLeftPos, this.f_97736_ + 50, 180);
        this.textureSkinLocationBox.m_94199_(255);
        this.textureSkinLocationBox.m_94144_("");
        this.textureSkinLocationBox.m_94151_(consumer -> this.validateTextureSkinLocation());
        this.m_142416_((GuiEventListener)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.textureSkinLocationBox.f_93620_ + this.textureSkinLocationBox.m_5711_() + 2, this.f_97736_ + 50, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.f_93623_ = false;
        this.clearTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.addTextureSettingsButton.f_93620_ + this.addTextureSettingsButton.m_5711_() + 1, this.f_97736_ + 50, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        this.clearTextureSettingsButton.f_93623_ = false;
        int skinButtonTop = this.f_97736_ + 187;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.rightPos - 29;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, (Component)new TextComponent("<<"), onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, (Component)new TextComponent("<"), onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, (Component)new TextComponent(">>"), onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, (Component)new TextComponent(">"), onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (this.addTextureSettingsButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "use_a_player_name", this.contentLeftPos, this.addTextureSettingsButton.f_93621_ - 10);
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_CONFIGURATION);
            poseStack.m_85837_(0.0, 0.0, 100.0);
            this.m_93228_(poseStack, this.f_97735_ + 176, this.f_97736_ + 53, 82, 1, 8, 10);
            if (!TextureManager.hasLastErrorMessage()) {
                Text.drawConfigString(poseStack, this.f_96547_, "processing_url_skin", this.f_97735_ + 55, this.f_97736_ + 80);
            }
        }
        if (TextureManager.hasLastErrorMessage()) {
            List textComponents = this.f_96547_.m_92923_((FormattedText)new TextComponent(TextureManager.getLastErrorMessage()), this.f_97726_ - 14);
            int line = 0;
            for (FormattedCharSequence formattedCharSequence : textComponents) {
                int n = line++;
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(poseStack, this.f_96547_, formattedCharSequence, this.f_97735_ + 10, this.f_97736_ + 71 + n * (9 + 2), 0xFF5555);
            }
        }
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6305_(poseStack, x, y, partialTicks);
            }
        }
        this.renderSkins(poseStack);
    }
}

