/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationScreen;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.trading.CustomTradingConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomTradingConfigurationScreen
extends TradingConfigurationScreen<CustomTradingConfigurationMenu> {
    private static TradingType formerTradingType = TradingType.BASIC;
    protected final TradingData<?> tradingData;
    protected Checkbox noneTradingCheckbox;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public CustomTradingConfigurationScreen(CustomTradingConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.tradingData = this.easyNPC.getEasyNPCTradingData();
    }

    public static void setFormerTradingType(TradingType dialogType) {
        formerTradingType = dialogType;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customTradesButton.f_93623_ = false;
        CustomTradingConfigurationScreen.setFormerTradingType(this.tradingData.getTradingType());
        this.noneTradingCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 100, this.f_97736_ + 170, "custom_trading_checkbox", this.tradingData.getTradingType() == TradingType.CUSTOM, checkbox -> {
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.changeTradingType(this.uuid, TradingType.CUSTOM);
            } else {
                ServerNetworkMessageHandler.changeTradingType(this.uuid, formerTradingType != null && formerTradingType != TradingType.NONE ? formerTradingType : TradingType.NONE);
            }
        }));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("text.easy_npc.config.custom_trading_text"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(poseStack, this.f_96547_, formattedCharSequence, this.f_97735_ + 15, this.f_97736_ + 60 + line * (9 + 2));
            }
        }
    }
}

