/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.editor.DialogButtonEditorMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogButtonEditorScreen
extends AbstractContainerScreen<DialogButtonEditorMenu> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final DialogDataSet dialogDataSet;
    protected final DialogDataEntry dialogData;
    protected final DialogButtonData dialogButtonData;
    protected final EasyNPC<?> easyNPC;
    protected final UUID dialogId;
    protected final UUID dialogButtonId;
    protected final UUID uuid;
    protected final ConfigurationType formerConfigurationType;
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogButtonButton;
    protected Button closeButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField buttonNameBox;
    protected Button buttonNameToLabelButton;
    protected TextField buttonLabelBox;
    protected Checkbox buttonLabelCheckbox;
    protected TextField openNamedDialogBox;
    protected Checkbox openTradingScreenCheckbox;
    protected TextField commandDialogBox;
    protected Checkbox commandDialogExecuteAsUserCheckbox;
    protected Checkbox commandDialogDebugCheckbox;
    protected int bottomPos;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    private String buttonNameValue = "";
    private String buttonLabelValue = "";
    private String openNamedDialogValue = "";
    private String commandDialogValue = "";
    private boolean openTradingScreenValue = false;
    private boolean commandDialogExecuteAsUserValue = false;
    private boolean commandDialogDebugValue = false;

    @OnlyIn(value=Dist.CLIENT)
    public DialogButtonEditorScreen(DialogButtonEditorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.uuid = menu.getUUID();
        this.easyNPC = menu.getEasyNPC();
        this.dialogDataSet = menu.getDialogDataSet();
        this.dialogData = this.dialogDataSet.getDialog(menu.getDialogId());
        this.dialogButtonData = menu.getDialogButtonData();
        this.dialogId = menu.getDialogId();
        this.dialogButtonId = menu.getDialogButtonId();
        this.formerConfigurationType = menu.getFormerConfigurationType();
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance.f_91074_;
        this.clientLevel = this.minecraftInstance.f_91073_;
    }

    private void openPreviousScreen() {
        if (this.formerConfigurationType == ConfigurationType.DIALOG_EDITOR) {
            ServerNetworkMessageHandler.openDialogEditor(this.uuid, this.dialogId, this.formerConfigurationType);
        } else if (this.formerConfigurationType == ConfigurationType.ADVANCED_DIALOG) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_DIALOG);
        } else if (this.formerConfigurationType != null) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, this.formerConfigurationType);
        } else if (this.dialogDataSet.getType() == DialogType.YES_NO) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
        } else {
            this.closeScreen();
        }
    }

    private void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
    }

    private void deleteDialogButton() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                ServerNetworkMessageHandler.removeDialogButton(this.uuid, this.dialogId, this.dialogButtonId);
                this.openPreviousScreen();
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)new TranslatableComponent("text.easy_npc.removeDialogButton.deleteQuestion"), (Component)new TranslatableComponent("text.easy_npc.removeDialogButton.deleteWarning", new Object[]{this.dialogButtonData.getName()}), (Component)new TranslatableComponent("text.easy_npc.removeDialogButton.deleteButton"), CommonComponents.f_130656_));
    }

    protected void renderEditLabels(PoseStack poseStack) {
        Text.drawConfigString(poseStack, this.f_96547_, "button.name", this.f_97735_ + 12, this.buttonNameBox.f_93621_ + 4);
        Text.drawConfigString(poseStack, this.f_96547_, "label_id", this.f_97735_ + 12, this.buttonLabelBox.f_93621_ + 4);
        Text.drawConfigString(poseStack, this.f_96547_, "dialog_actions_on_click", this.f_97735_ + 12, this.openNamedDialogBox.f_93621_ - 16, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "open_named_dialog", this.f_97735_ + 12, this.openNamedDialogBox.f_93621_ + 4);
        Text.drawString(poseStack, this.f_96547_, "Actions", this.f_97735_ + 12, this.commandDialogBox.f_93621_ - 10);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 318;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(true);
        }
        ActionDataEntry openNamedDialogAction = this.dialogButtonData.getActionData(ActionType.OPEN_NAMED_DIALOG);
        ActionDataEntry openTradingScreenAction = this.dialogButtonData.getActionData(ActionType.OPEN_TRADING_SCREEN);
        ActionDataEntry commandAction = this.dialogButtonData.getActionData(ActionType.COMMAND);
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.f_97735_ + 7, this.f_97736_ + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogData.getName(21), onPress -> this.openPreviousScreen()));
        this.dialogButtonButton = (Button)this.m_142416_((GuiEventListener)new DialogButtonButton(this.dialogButton.f_93620_ + this.dialogButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogButtonData.getName(21), onPress -> {}));
        this.dialogButtonButton.f_93623_ = false;
        this.buttonNameValue = this.dialogButtonData.getName();
        this.buttonNameBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 30, 150);
        this.buttonNameBox.m_94199_(64);
        this.buttonNameBox.m_94144_(this.buttonNameValue);
        this.m_142416_((GuiEventListener)this.buttonNameBox);
        this.buttonNameToLabelButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.buttonNameBox.f_93620_ + this.buttonNameBox.m_5711_() + 1, this.buttonNameBox.f_93621_ - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.buttonNameBox != null && this.buttonLabelBox != null) {
                String buttonName = this.buttonNameBox.m_94155_();
                this.buttonLabelBox.m_94144_(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.buttonLabelValue = this.dialogButtonData.getLabel();
        this.buttonLabelBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 50, 100);
        this.buttonLabelBox.m_94199_(32);
        this.buttonLabelBox.m_94144_(this.buttonLabelValue);
        this.buttonLabelBox.m_94186_(false);
        this.m_142416_((GuiEventListener)this.buttonLabelBox);
        this.buttonLabelCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 204, this.buttonLabelBox.f_93621_ + 1, "locked", true, onPress -> this.buttonLabelBox.m_94186_(!this.buttonLabelCheckbox.selected())));
        this.openNamedDialogValue = openNamedDialogAction != null ? openNamedDialogAction.getCommand() : "";
        this.openNamedDialogBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 90, 100);
        this.openNamedDialogBox.m_94199_(32);
        this.openNamedDialogBox.m_94144_(this.openNamedDialogValue);
        this.openNamedDialogBox.m_94186_(openTradingScreenAction == null || openTradingScreenAction.getCommand() == null);
        this.m_142416_((GuiEventListener)this.openNamedDialogBox);
        this.openTradingScreenValue = openTradingScreenAction != null && openTradingScreenAction.getCommand() != null;
        this.openTradingScreenCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 100 + 104, this.openNamedDialogBox.f_93621_ + 1, "open_trading_screen", this.openTradingScreenValue, onPress -> this.openNamedDialogBox.m_94186_(!this.openTradingScreenCheckbox.selected())));
        this.commandDialogValue = commandAction != null ? commandAction.getCommand() : "";
        this.commandDialogBox = new TextField(this.f_96547_, this.f_97735_ + 10, this.f_97736_ + 130, 295);
        this.commandDialogBox.m_94199_(255);
        this.commandDialogBox.m_94144_(this.commandDialogValue);
        this.m_142416_((GuiEventListener)this.commandDialogBox);
        this.commandDialogExecuteAsUserValue = commandAction != null && commandAction.shouldExecuteAsUser();
        this.commandDialogExecuteAsUserCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 10 + 80, this.commandDialogBox.f_93621_ + 18, "execute_as_player", this.commandDialogExecuteAsUserValue));
        this.commandDialogDebugValue = commandAction != null && commandAction.isDebugEnabled();
        this.commandDialogDebugCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 10 + 215, this.commandDialogBox.f_93621_ + 18, "debug", this.commandDialogDebugValue));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.f_97735_ + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.dialogButtonData.setName(this.buttonNameBox.m_94155_());
            this.dialogButtonData.setLabel(this.buttonLabelBox.m_94155_());
            HashSet<ActionDataEntry> actionDataEntrySet = new HashSet<ActionDataEntry>();
            if (this.openTradingScreenCheckbox.selected()) {
                ActionDataEntry openTradingScreenActionDataEntry = new ActionDataEntry(ActionType.OPEN_TRADING_SCREEN);
                actionDataEntrySet.add(openTradingScreenActionDataEntry);
            } else if (!this.openNamedDialogBox.m_94155_().isEmpty()) {
                ActionDataEntry openNamedDialogActionDataEntry = new ActionDataEntry(ActionType.OPEN_NAMED_DIALOG, this.openNamedDialogBox.m_94155_());
                actionDataEntrySet.add(openNamedDialogActionDataEntry);
            }
            ActionDataEntry commandActionDataEntry = new ActionDataEntry(ActionType.COMMAND, this.commandDialogBox.m_94155_(), this.commandDialogExecuteAsUserCheckbox.selected(), this.commandDialogDebugCheckbox.selected());
            actionDataEntrySet.add(commandActionDataEntry);
            this.dialogButtonData.setActionData(actionDataEntrySet);
            ServerNetworkMessageHandler.saveDialogButton(this.uuid, this.dialogId, this.dialogButtonId, this.dialogButtonData);
            this.openPreviousScreen();
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.f_93620_ + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialogButton()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.f_93620_ + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.buttonNameBox.m_94155_().equals(this.buttonNameValue) || !this.buttonLabelBox.m_94155_().equals(this.buttonLabelValue) || !this.openNamedDialogBox.m_94155_().equals(this.openNamedDialogValue) || !this.commandDialogBox.m_94155_().equals(this.commandDialogValue) || this.openTradingScreenCheckbox.selected() != this.openTradingScreenValue || this.commandDialogExecuteAsUserCheckbox.selected() != this.commandDialogExecuteAsUserValue || this.commandDialogDebugCheckbox.selected() != this.commandDialogDebugValue;
        }
        if (this.buttonLabelCheckbox != null && this.buttonNameToLabelButton != null) {
            this.buttonNameToLabelButton.f_93623_ = !this.buttonLabelCheckbox.selected();
        }
    }

    public void m_7861_() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
        super.m_7861_();
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderEditLabels(poseStack);
        this.xMouse = x;
        this.yMouse = y;
        if (this.buttonNameToLabelButton.m_5953_((double)x, (double)y)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("text.easy_npc.config.name_to_label.tooltip"), x, y);
        }
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_, 132, 0, 120, 160);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_ + 77, 132, 5, 120, 170);
        DialogButtonEditorScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 6), (int)(this.f_97736_ + 110), (int)(this.rightPos - 6), (int)(this.commandDialogBox.f_93621_ + 70), (int)-16777216);
        DialogButtonEditorScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 7), (int)(this.f_97736_ + 111), (int)(this.rightPos - 7), (int)(this.commandDialogBox.f_93621_ + 69), (int)-2236963);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

