/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.editor.DialogTextEditorMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogTextEditorScreen
extends AbstractContainerScreen<DialogTextEditorMenu> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final int MAX_NUMBER_OF_DIALOG_TEXTS = 6;
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final DialogDataSet dialogDataSet;
    protected final DialogDataEntry dialogData;
    protected final Set<DialogTextData> dialogTexts;
    protected final EasyNPC<?> easyNPC;
    protected final UUID uuid;
    protected final ConfigurationType formerConfigurationType;
    protected final UUID dialogId;
    private final Set<TextField> dialogTextFields = new HashSet<TextField>();
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogTextButton;
    protected Button closeButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Checkbox translateCheckbox;
    protected int bottomPos;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;

    @OnlyIn(value=Dist.CLIENT)
    public DialogTextEditorScreen(DialogTextEditorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.uuid = menu.getUUID();
        this.easyNPC = menu.getEasyNPC();
        this.dialogDataSet = menu.getDialogDataSet();
        this.dialogData = menu.getDialogData();
        this.dialogTexts = this.dialogData.getDialogTexts();
        this.dialogId = menu.getDialogId();
        this.formerConfigurationType = menu.getFormerConfigurationType();
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance.f_91074_;
        this.clientLevel = this.minecraftInstance.f_91073_;
    }

    private void openPreviousScreen() {
        if (this.formerConfigurationType == ConfigurationType.DIALOG_EDITOR) {
            ServerNetworkMessageHandler.openDialogEditor(this.uuid, this.dialogId, this.formerConfigurationType);
        } else if (this.formerConfigurationType == ConfigurationType.ADVANCED_DIALOG) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_DIALOG);
        } else if (this.formerConfigurationType != null) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, this.formerConfigurationType);
        } else if (this.dialogDataSet.getType() == DialogType.YES_NO) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
        } else {
            this.closeScreen();
        }
    }

    private void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
    }

    protected void saveDialogData() {
        HashSet<DialogTextData> validDialogTexts = new HashSet<DialogTextData>();
        for (TextField textfield : this.dialogTextFields) {
            String text = textfield.m_94155_();
            if (text.isEmpty()) continue;
            validDialogTexts.add(new DialogTextData(text, this.translateCheckbox.selected()));
        }
        this.dialogData.setDialogTexts(validDialogTexts);
        ServerNetworkMessageHandler.saveDialog(this.uuid, this.dialogId, this.dialogData);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 318;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(true);
        }
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.f_97735_ + 7, this.f_97736_ + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogData.getName(21), onPress -> this.openPreviousScreen()));
        this.dialogTextButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.dialogButton.f_93620_ + this.dialogButton.m_5711_(), this.f_97736_ + 7, 140, "Dialog Text", onPress -> {}));
        this.dialogTextButton.f_93623_ = false;
        int dialogTextIndex = 0;
        int dialogTextLeftPos = this.f_97735_ + 20;
        int dialogTextTopPos = this.f_97736_ + 50;
        int dialogTextWidth = 290;
        boolean dialogTextTranslatable = false;
        for (DialogTextData dialogText : this.dialogTexts) {
            if (dialogTextIndex >= 6) break;
            TextField textfield = (TextField)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, dialogTextLeftPos, dialogTextTopPos + dialogTextIndex * 20, dialogTextWidth, dialogText.getText(), 512));
            this.dialogTextFields.add(textfield);
            if (dialogText.getTranslate()) {
                dialogTextTranslatable = true;
            }
            ++dialogTextIndex;
        }
        for (int i = dialogTextIndex; i < 6; ++i) {
            TextField textfield = (TextField)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, dialogTextLeftPos, dialogTextTopPos + i * 20, dialogTextWidth, "", 512));
            this.dialogTextFields.add(textfield);
        }
        this.translateCheckbox = new Checkbox(this.f_97735_ + 20, this.bottomPos - 70, "dialog.translate", dialogTextTranslatable);
        this.m_142416_((GuiEventListener)this.translateCheckbox);
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.f_97735_ + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.saveButton.f_93620_ + 95 + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    protected void renderEditLabels(PoseStack poseStack) {
        Text.drawConfigString(poseStack, this.f_96547_, "dialog.text", this.f_97735_ + 10, this.f_97736_ + 34, 0);
        for (int i = 1; i <= 6; ++i) {
            Text.drawString(poseStack, this.f_96547_, i + ":", this.f_97735_ + 10, this.f_97736_ + 35 + i * 20, 0);
        }
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderEditLabels(poseStack);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_, 132, 0, 120, 160);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_ + 77, 132, 5, 120, 170);
    }

    public void m_7861_() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
        super.m_7861_();
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

