/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.selector.EasyNPCSelectorParser;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;

public class EasyNPCArgument
implements ArgumentType<EntitySelector> {
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.entity.notfound.entity"));
    private static final Collection<String> EXAMPLES = Arrays.asList("EasyNPC", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");

    public static EasyNPC<?> getEntityWithAccess(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        EasyNPC easyNPC = EasyNPCArgument.getEntitiesWithAccess(context, name).stream().findFirst().orElse(null);
        if (easyNPC == null) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPC;
    }

    public static Collection<? extends EasyNPC<?>> getEntitiesWithAccess(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Collection<EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntities(context, name);
        if (!easyNPCs.isEmpty()) {
            for (EasyNPC<?> easyNPC : easyNPCs) {
                if (AccessManager.hasAccess((CommandSourceStack)context.getSource(), easyNPC.getUUID())) continue;
                easyNPCs = easyNPCs.stream().filter(e -> e != easyNPC).toList();
            }
        }
        if (easyNPCs.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPCs;
    }

    public static EasyNPC<?> getEntity(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        EasyNPC easyNPC = EasyNPCArgument.getEntities(context, name).stream().findFirst().orElse(null);
        if (easyNPC == null) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPC;
    }

    public static Collection<? extends EasyNPC<?>> getEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Collection<EasyNPC<?>> entities = EasyNPCArgument.getOptionalEntities(context, name);
        if (entities.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return entities;
    }

    public static Collection<? extends EasyNPC<?>> getOptionalEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        List entities = ((EntitySelector)context.getArgument(name, EntitySelector.class)).m_121160_((CommandSourceStack)context.getSource());
        ArrayList<EasyNPC> easyNPCs = new ArrayList<EasyNPC>();
        for (Entity entity : entities) {
            if (!(entity instanceof EasyNPC)) continue;
            EasyNPC easyNPC = (EasyNPC)entity;
            easyNPCs.add(easyNPC);
        }
        return easyNPCs;
    }

    public EntitySelector parse(StringReader stringReader) throws CommandSyntaxException {
        EasyNPCSelectorParser entitySelectorParser = new EasyNPCSelectorParser(stringReader);
        return entitySelectorParser.m_121377_();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        Object object = context.getSource();
        if (!(object instanceof SharedSuggestionProvider)) {
            return Suggestions.empty();
        }
        SharedSuggestionProvider sharedSuggestionProvider = (SharedSuggestionProvider)object;
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        EasyNPCSelectorParser easyNPCSelectorParser = new EasyNPCSelectorParser(stringReader, sharedSuggestionProvider.m_6761_(2));
        try {
            easyNPCSelectorParser.m_121377_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return easyNPCSelectorParser.m_121249_(suggestionsBuilder, consumer -> {
            Collection result = sharedSuggestionProvider.m_6264_();
            SharedSuggestionProvider.m_82970_((Iterable)result, (SuggestionsBuilder)consumer);
        });
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

