/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private CommonConfig() {
    }

    public static String getEnableComment(String name) {
        return "Enable " + name + " configuration.";
    }

    public static String getAllowInCreativeComment(String name) {
        return "Allow " + name + " configuration in creative mode.";
    }

    public static String getPermissionLevelComment(String name) {
        return name + " configuration permission level. (0 = everyone, 1 = moderator, 2 = gamemaster, 3 = admin, 4 = owner)";
    }

    static {
        log = LogManager.getLogger((String)"Easy NPC");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Easy NPC");
        try {
            FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get(), (String)"easy_npc");
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "easy_npc/easy_npc-common.toml");
    }

    public static class Config {
        public static final String MAIN_CONFIGURATION = "main";
        public static final String ABILITIES_ATTRIBUTE_CONFIGURATION = "abilities attribute";
        public static final String BASE_ATTRIBUTE_CONFIGURATION = "base attribute";
        public static final String DISPLAY_ATTRIBUTE_CONFIGURATION = "display attribute";
        public static final String BASIC_ACTION_CONFIGURATION = "basic action";
        public static final String DIALOG_ACTION_CONFIGURATION = "dialog action";
        public static final String DISTANCE_ACTION_CONFIGURATION = "distance action";
        public static final String BASIC_DIALOG_CONFIGURATION = "basic dialog";
        public static final String YES_NO_DIALOG_CONFIGURATION = "yes/no dialog";
        public static final String NONE_DIALOG_CONFIGURATION = "none dialog";
        public static final String ADVANCED_DIALOG_CONFIGURATION = "advanced dialog";
        public static final String NONE_SKIN_CONFIGURATION = "none skin";
        public static final String DEFAULT_SKIN_CONFIGURATION = "default skin";
        public static final String PLAYER_SKIN_CONFIGURATION = "player skin";
        public static final String URL_SKIN_CONFIGURATION = "url skin";
        public static final String CUSTOM_SKIN_CONFIGURATION = "custom skin";
        public static final String DEFAULT_POSE_CONFIGURATION = "default pose";
        public static final String CUSTOM_POSE_CONFIGURATION = "custom pose";
        public static final String DEFAULT_EQUIPMENT_CONFIGURATION = "equipment";
        public static final String DEFAULT_POSITION_CONFIGURATION = "position";
        public static final String DEFAULT_ROTATION_CONFIGURATION = "rotation";
        public static final String DEFAULT_SCALE_CONFIGURATION = "scale";
        public static final String CUSTOM_EXPORT_PRESET_CONFIGURATION = "custom export preset";
        public static final String WORLD_EXPORT_PRESET_CONFIGURATION = "world export preset";
        public static final String LOCAL_IMPORT_PRESET_CONFIGURATION = "local import preset";
        public static final String CUSTOM_IMPORT_PRESET_CONFIGURATION = "custom import preset";
        public static final String DEFAULT_IMPORT_PRESET_CONFIGURATION = "default import preset";
        public static final String WORLD_IMPORT_PRESET_CONFIGURATION = "world import preset";
        public static final String NONE_TRADING_CONFIGURATION = "none trading";
        public static final String BASIC_TRADING_CONFIGURATION = "basic trading";
        public static final String ADVANCED_TRADING_CONFIGURATION = "advanced trading";
        public static final String CUSTOM_TRADING_CONFIGURATION = "custom trading";
        public static final String BASIC_OBJECTIVE_CONFIGURATION = "basic objective";
        public static final String ATTACK_OBJECTIVE_CONFIGURATION = "attack objective";
        public static final String FOLLOW_OBJECTIVE_CONFIGURATION = "follow objective";
        public static final String LOOK_OBJECTIVE_CONFIGURATION = "look objective";
        private static final String ADVANCED_POSE_CONFIGURATION = "advanced pose";
        public final ForgeConfigSpec.BooleanValue mainConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue mainConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue mainConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue abilitiesAttributeConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue abilitiesAttributeConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue abilitiesAttributeConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue baseAttributeConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue baseAttributeConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue baseAttributeConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue displayAttributeConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue displayAttributeConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue displayAttributeConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue basicActionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicActionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicActionConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue dialogActionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue dialogActionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue dialogActionConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue distanceActionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue distanceActionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue distanceActionConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue basicDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicDialogConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue yesNoDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue yesNoDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue yesNoDialogConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue noneDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue noneDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue noneDialogConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue advancedDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue advancedDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue advancedDialogConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue noneSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue noneSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue noneSkinConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue defaultSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultSkinConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue playerSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue playerSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue playerSkinConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue urlSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue urlSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue urlSkinConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue customSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customSkinConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue defaultPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultPoseConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue advancedPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue advancedPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue advancedPoseConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue customPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customPoseConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue equipmentConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue equipmentConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue equipmentConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue defaultPositionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultPositionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultPositionConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue defaultRotationConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultRotationConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultRotationConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue scalingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue scalingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue scalingConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue customExportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customExportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customExportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue worldExportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue worldExportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue worldExportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue localImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue localImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue localImportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue customImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customImportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue defaultImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultImportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue worldImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue worldImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue worldImportPresetConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue noneTradingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue noneTradingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue noneTradingConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue basicTradingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicTradingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicTradingConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue advancedTradingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue advancedTradingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue advancedTradingConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue customTradingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customTradingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customTradingConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue basicObjectiveConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicObjectiveConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicObjectiveConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue attackObjectiveConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue attackObjectiveConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue attackObjectiveConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue followObjectiveConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue followObjectiveConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue followObjectiveConfigurationPermissionLevel;
        public final ForgeConfigSpec.BooleanValue lookObjectiveConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue lookObjectiveConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue lookObjectiveConfigurationPermissionLevel;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Easy NPC");
            builder.push("General Configuration");
            builder.pop();
            builder.push("[Main Configuration]");
            this.mainConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(MAIN_CONFIGURATION)).define("mainConfigurationEnabled", true);
            this.mainConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(MAIN_CONFIGURATION)).define("mainConfigurationAllowInCreative", true);
            this.mainConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(MAIN_CONFIGURATION)).defineInRange("mainConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Action Configuration] Basic Action");
            this.basicActionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_ACTION_CONFIGURATION)).define("basicActionConfigurationEnabled", true);
            this.basicActionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_ACTION_CONFIGURATION)).define("basicActionConfigurationAllowInCreative", true);
            this.basicActionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_ACTION_CONFIGURATION)).defineInRange("basicActionConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Action Configuration] Dialog Action");
            this.dialogActionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DIALOG_ACTION_CONFIGURATION)).define("dialogActionConfigurationEnabled", true);
            this.dialogActionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DIALOG_ACTION_CONFIGURATION)).define("dialogActionConfigurationAllowInCreative", true);
            this.dialogActionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DIALOG_ACTION_CONFIGURATION)).defineInRange("dialogActionConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Action Configuration] Distance Action");
            this.distanceActionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DISTANCE_ACTION_CONFIGURATION)).define("distanceActionConfigurationEnabled", true);
            this.distanceActionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DISTANCE_ACTION_CONFIGURATION)).define("distanceActionConfigurationAllowInCreative", true);
            this.distanceActionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DISTANCE_ACTION_CONFIGURATION)).defineInRange("distanceActionConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Attribute Configuration] Abilities Attribute");
            this.abilitiesAttributeConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ABILITIES_ATTRIBUTE_CONFIGURATION)).define("abilitiesAttributeConfigurationEnabled", true);
            this.abilitiesAttributeConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ABILITIES_ATTRIBUTE_CONFIGURATION)).define("abilitiesAttributeConfigurationAllowInCreative", true);
            this.abilitiesAttributeConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ABILITIES_ATTRIBUTE_CONFIGURATION)).defineInRange("abilitiesAttributeConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Attribute Configuration] Base Attribute");
            this.baseAttributeConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASE_ATTRIBUTE_CONFIGURATION)).define("baseAttributeConfigurationEnabled", true);
            this.baseAttributeConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASE_ATTRIBUTE_CONFIGURATION)).define("baseAttributeConfigurationAllowInCreative", true);
            this.baseAttributeConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASE_ATTRIBUTE_CONFIGURATION)).defineInRange("baseAttributeConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Attribute Configuration] Display Attribute");
            this.displayAttributeConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DISPLAY_ATTRIBUTE_CONFIGURATION)).define("displayAttributeConfigurationEnabled", true);
            this.displayAttributeConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DISPLAY_ATTRIBUTE_CONFIGURATION)).define("displayAttributeConfigurationAllowInCreative", true);
            this.displayAttributeConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DISPLAY_ATTRIBUTE_CONFIGURATION)).defineInRange("displayAttributeConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Dialog Configuration] None Dialog");
            this.noneDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(NONE_DIALOG_CONFIGURATION)).define("noneDialogConfigurationEnabled", true);
            this.noneDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(NONE_DIALOG_CONFIGURATION)).define("noneDialogConfigurationAllowInCreative", true);
            this.noneDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(NONE_DIALOG_CONFIGURATION)).defineInRange("noneDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Dialog Configuration] Basic Dialog");
            this.basicDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_DIALOG_CONFIGURATION)).define("basicDialogConfigurationEnabled", true);
            this.basicDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_DIALOG_CONFIGURATION)).define("basicDialogConfigurationAllowInCreative", true);
            this.basicDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_DIALOG_CONFIGURATION)).defineInRange("basicDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Dialog Configuration] Yes/No Dialog");
            this.yesNoDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(YES_NO_DIALOG_CONFIGURATION)).define("yesNoDialogConfigurationEnabled", true);
            this.yesNoDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(YES_NO_DIALOG_CONFIGURATION)).define("yesNoDialogConfigurationAllowInCreative", true);
            this.yesNoDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(YES_NO_DIALOG_CONFIGURATION)).defineInRange("yesNoDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Dialog Configuration] Advanced Dialog");
            this.advancedDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ADVANCED_DIALOG_CONFIGURATION)).define("advancedDialogConfigurationEnabled", true);
            this.advancedDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ADVANCED_DIALOG_CONFIGURATION)).define("advancedDialogConfigurationAllowInCreative", true);
            this.advancedDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ADVANCED_DIALOG_CONFIGURATION)).defineInRange("advancedDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Skin Configuration] None Skin");
            this.noneSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(NONE_SKIN_CONFIGURATION)).define("noneSkinConfigurationEnabled", true);
            this.noneSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(NONE_SKIN_CONFIGURATION)).define("noneSkinConfigurationAllowInCreative", true);
            this.noneSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(NONE_SKIN_CONFIGURATION)).defineInRange("noneSkinConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Skin Configuration] Default Skin");
            this.defaultSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_SKIN_CONFIGURATION)).define("defaultSkinConfigurationEnabled", true);
            this.defaultSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_SKIN_CONFIGURATION)).define("defaultSkinConfigurationAllowInCreative", true);
            this.defaultSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_SKIN_CONFIGURATION)).defineInRange("defaultSkinConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Skin Configuration] Player Skin");
            this.playerSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(PLAYER_SKIN_CONFIGURATION)).define("playerSkinConfigurationEnabled", true);
            this.playerSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(PLAYER_SKIN_CONFIGURATION)).define("playerSkinConfigurationAllowInCreative", true);
            this.playerSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(PLAYER_SKIN_CONFIGURATION)).defineInRange("playerSkinConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Skin Configuration] URL Skin");
            this.urlSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(URL_SKIN_CONFIGURATION)).define("urlSkinConfigurationEnabled", true);
            this.urlSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(URL_SKIN_CONFIGURATION)).define("urlSkinConfigurationAllowInCreative", true);
            this.urlSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(URL_SKIN_CONFIGURATION)).defineInRange("urlSkinConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("[Skin Configuration] Custom Skin");
            this.customSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_SKIN_CONFIGURATION)).define("customSkinConfigurationEnabled", true);
            this.customSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_SKIN_CONFIGURATION)).define("customSkinConfigurationAllowInCreative", true);
            this.customSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_SKIN_CONFIGURATION)).defineInRange("customSkinConfigurationPermissionLevel", 2, 0, 4);
            builder.pop();
            builder.push("[Pose Configuration] Default Pose");
            this.defaultPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_POSE_CONFIGURATION)).define("defaultPoseConfigurationEnabled", true);
            this.defaultPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_POSE_CONFIGURATION)).define("defaultPoseConfigurationAllowInCreative", true);
            this.defaultPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_POSE_CONFIGURATION)).defineInRange("defaultPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Pose Configuration] Advanced Pose");
            this.advancedPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ADVANCED_POSE_CONFIGURATION)).define("advancedPoseConfigurationEnabled", true);
            this.advancedPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ADVANCED_POSE_CONFIGURATION)).define("advancedPoseConfigurationAllowInCreative", true);
            this.advancedPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ADVANCED_POSE_CONFIGURATION)).defineInRange("advancedPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.push("[Pose Configuration] Custom Pose");
            this.customPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_POSE_CONFIGURATION)).define("customPoseConfigurationEnabled", true);
            this.customPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_POSE_CONFIGURATION)).define("customPoseConfigurationAllowInCreative", true);
            this.customPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_POSE_CONFIGURATION)).defineInRange("customPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Equipment Configuration]");
            this.equipmentConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_EQUIPMENT_CONFIGURATION)).define("equipmentConfigurationEnabled", true);
            this.equipmentConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_EQUIPMENT_CONFIGURATION)).define("equipmentConfigurationAllowInCreative", true);
            this.equipmentConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_EQUIPMENT_CONFIGURATION)).defineInRange("equipmentConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Position Configuration]");
            this.defaultPositionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_POSITION_CONFIGURATION)).define("defaultPositionConfigurationEnabled", true);
            this.defaultPositionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_POSITION_CONFIGURATION)).define("defaultPositionConfigurationAllowInCreative", true);
            this.defaultPositionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_POSITION_CONFIGURATION)).defineInRange("defaultPositionConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Rotation Configuration]");
            this.defaultRotationConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_ROTATION_CONFIGURATION)).define("defaultRotationConfigurationEnabled", true);
            this.defaultRotationConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_ROTATION_CONFIGURATION)).define("defaultRotationConfigurationAllowInCreative", true);
            this.defaultRotationConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_ROTATION_CONFIGURATION)).defineInRange("defaultRotationConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Scale Configuration]");
            this.scalingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_SCALE_CONFIGURATION)).define("scaleConfigurationEnabled", true);
            this.scalingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_SCALE_CONFIGURATION)).define("scaleConfigurationAllowInCreative", true);
            this.scalingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_SCALE_CONFIGURATION)).defineInRange("scaleConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Export Configuration] Export Custom Preset");
            this.customExportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).define("customExportPresetConfigurationEnabled", true);
            this.customExportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).define("customExportPresetConfigurationAllowInCreative", true);
            this.customExportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).defineInRange("customExportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Export Configuration] Export World Preset");
            this.worldExportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(WORLD_EXPORT_PRESET_CONFIGURATION)).define("worldExportPresetConfigurationEnabled", true);
            this.worldExportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(WORLD_EXPORT_PRESET_CONFIGURATION)).define("worldExportPresetConfigurationAllowInCreative", true);
            this.worldExportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(WORLD_EXPORT_PRESET_CONFIGURATION)).defineInRange("worldExportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Import Configuration] Import Default Preset");
            this.defaultImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).define("defaultImportPresetConfigurationEnabled", true);
            this.defaultImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).define("defaultImportPresetConfigurationAllowInCreative", true);
            this.defaultImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).defineInRange("defaultImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Import Configuration] Import Local Preset");
            this.localImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(LOCAL_IMPORT_PRESET_CONFIGURATION)).define("localImportPresetConfigurationEnabled", true);
            this.localImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(LOCAL_IMPORT_PRESET_CONFIGURATION)).define("localImportPresetConfigurationAllowInCreative", true);
            this.localImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(LOCAL_IMPORT_PRESET_CONFIGURATION)).defineInRange("localImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Import Configuration] Import Custom Preset");
            this.customImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).define("customImportPresetConfigurationEnabled", true);
            this.customImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).define("customImportPresetConfigurationAllowInCreative", true);
            this.customImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).defineInRange("customImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Import Configuration] Import Server Preset");
            this.worldImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(WORLD_IMPORT_PRESET_CONFIGURATION)).define("worldImportPresetConfigurationEnabled", true);
            this.worldImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(WORLD_IMPORT_PRESET_CONFIGURATION)).define("worldImportPresetConfigurationAllowInCreative", true);
            this.worldImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(WORLD_IMPORT_PRESET_CONFIGURATION)).defineInRange("worldImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Trading Configuration] Default Trading");
            this.noneTradingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(NONE_TRADING_CONFIGURATION)).define("noneTradingConfigurationEnabled", true);
            this.noneTradingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(NONE_TRADING_CONFIGURATION)).define("noneTradingConfigurationAllowInCreative", true);
            this.noneTradingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(NONE_TRADING_CONFIGURATION)).defineInRange("noneTradingConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Trading Configuration] Basic Trading");
            this.basicTradingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_TRADING_CONFIGURATION)).define("basicTradingConfigurationEnabled", true);
            this.basicTradingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_TRADING_CONFIGURATION)).define("basicTradingConfigurationAllowInCreative", true);
            this.basicTradingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_TRADING_CONFIGURATION)).defineInRange("basicTradingConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Trading Configuration] Advanced Trading");
            this.advancedTradingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ADVANCED_TRADING_CONFIGURATION)).define("advancedTradingConfigurationEnabled", true);
            this.advancedTradingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ADVANCED_TRADING_CONFIGURATION)).define("advancedTradingConfigurationAllowInCreative", true);
            this.advancedTradingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ADVANCED_TRADING_CONFIGURATION)).defineInRange("advancedTradingConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Trading Configuration] Custom Trading");
            this.customTradingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_TRADING_CONFIGURATION)).define("customTradingConfigurationEnabled", true);
            this.customTradingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_TRADING_CONFIGURATION)).define("customTradingConfigurationAllowInCreative", true);
            this.customTradingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_TRADING_CONFIGURATION)).defineInRange("customTradingConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Objective Configuration] Basic Objective");
            this.basicObjectiveConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_OBJECTIVE_CONFIGURATION)).define("basicObjectiveConfigurationEnabled", true);
            this.basicObjectiveConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_OBJECTIVE_CONFIGURATION)).define("basicObjectiveConfigurationAllowInCreative", true);
            this.basicObjectiveConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_OBJECTIVE_CONFIGURATION)).defineInRange("basicObjectiveConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Objective Configuration] Attack Objective");
            this.attackObjectiveConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ATTACK_OBJECTIVE_CONFIGURATION)).define("attackObjectiveConfigurationEnabled", true);
            this.attackObjectiveConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ATTACK_OBJECTIVE_CONFIGURATION)).define("attackObjectiveConfigurationAllowInCreative", true);
            this.attackObjectiveConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ATTACK_OBJECTIVE_CONFIGURATION)).defineInRange("attackObjectiveConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Objective Configuration] Follow Objective");
            this.followObjectiveConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(FOLLOW_OBJECTIVE_CONFIGURATION)).define("followObjectiveConfigurationEnabled", true);
            this.followObjectiveConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(FOLLOW_OBJECTIVE_CONFIGURATION)).define("followObjectiveConfigurationAllowInCreative", true);
            this.followObjectiveConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(FOLLOW_OBJECTIVE_CONFIGURATION)).defineInRange("followObjectiveConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("[Objective Configuration] Look Objective");
            this.lookObjectiveConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(LOOK_OBJECTIVE_CONFIGURATION)).define("lookObjectiveConfigurationEnabled", true);
            this.lookObjectiveConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(LOOK_OBJECTIVE_CONFIGURATION)).define("lookObjectiveConfigurationAllowInCreative", true);
            this.lookObjectiveConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(LOOK_OBJECTIVE_CONFIGURATION)).defineInRange("lookObjectiveConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
        }
    }
}

