/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.utils.TextFormattingCodes;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DialogUtils {
    private static final String MACRO_NPC_STRING = "@npc";
    private static final String MACRO_INITIATOR_STRING = "@initiator";
    private static final int MAX_DIALOG_LINE_LENGTH = 178;
    private static final int MAX_SMALL_BUTTON_NAME_LENGTH = 20;

    protected DialogUtils() {
    }

    public static String parseDialogText(String text, LivingEntity entity, Player player) {
        if (DialogUtils.hasDialogMacros(text)) {
            if (entity != null) {
                text = text.replace(MACRO_NPC_STRING, entity.m_7755_().getString());
            }
            if (player != null) {
                text = text.replace(MACRO_INITIATOR_STRING, player.m_7755_().getString());
            }
        }
        text = TextFormattingCodes.parseTextLineBreaks(text);
        text = TextFormattingCodes.parseTextFormattingCodes(text);
        return text;
    }

    public static boolean hasDialogMacros(String text) {
        return text != null && !text.isEmpty() && (text.contains(MACRO_NPC_STRING) || text.contains(MACRO_INITIATOR_STRING));
    }

    public static String generateButtonLabel(String name) {
        return DialogUtils.generateLabel(name, "button", 32);
    }

    public static String generateDialogLabel(String name) {
        return DialogUtils.generateLabel(name, "dialog", 32);
    }

    private static String generateLabel(String name, String type, int maxLength) {
        if (name == null || name.isEmpty()) {
            return type + "_" + UUID.randomUUID().toString().substring(0, 8).replace("-", "").toLowerCase();
        }
        String label = name.trim().toLowerCase();
        label = label.replace(" ", "_");
        return (label = label.replaceAll("[^a-z0-9_]", "")).length() > maxLength ? label.substring(0, maxLength) : label;
    }

    public static int getNumbersOfDialogLines(String text, Font font) {
        return DialogUtils.getNumbersOfDialogLines(text, 178, font);
    }

    public static int getNumbersOfDialogLines(String text, int maxLineLength, Font font) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        TextComponent textComponent = new TextComponent(text);
        return font.m_92923_((FormattedText)textComponent, maxLineLength).size();
    }

    public static DialogDataSet getBasicDialog(String dialog) {
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.BASIC);
        DialogDataEntry dialogData = new DialogDataEntry("Basic Dialog", dialog, false);
        dialogDataSet.addDialog(dialogData);
        return dialogDataSet;
    }

    public static DialogDataSet getYesNoDialog(String dialogText, String yesButtonText, String noButtonText, String yesDialogText, String noDialogText) {
        HashSet<ActionDataEntry> yesActionDatumEntries = new HashSet<ActionDataEntry>();
        yesActionDatumEntries.add(new ActionDataEntry(ActionType.OPEN_NAMED_DIALOG, "yes_answer"));
        HashSet<ActionDataEntry> noActionDatumEntries = new HashSet<ActionDataEntry>();
        noActionDatumEntries.add(new ActionDataEntry(ActionType.OPEN_NAMED_DIALOG, "no_answer"));
        DialogButtonData yesButtonData = new DialogButtonData(yesButtonText, "yes_button", yesActionDatumEntries);
        DialogButtonData noButtonData = new DialogButtonData(noButtonText, "no_button", noActionDatumEntries);
        LinkedHashSet<DialogButtonData> buttons = new LinkedHashSet<DialogButtonData>();
        buttons.add(yesButtonData);
        buttons.add(noButtonData);
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.YES_NO);
        dialogDataSet.addDefaultDialog(new DialogDataEntry("question", "Question Dialog", dialogText, false, buttons));
        dialogDataSet.addDialog(new DialogDataEntry("yes_answer", "Yes Dialog", yesDialogText, false));
        dialogDataSet.addDialog(new DialogDataEntry("no_answer", "No Dialog", noDialogText, false));
        return dialogDataSet;
    }

    public static DialogScreenLayout getDialogScreenLayout(DialogDataEntry dialogData, Font font) {
        boolean hasLargeButtonName;
        if (dialogData == null) {
            return DialogScreenLayout.UNKNOWN;
        }
        boolean hasText = !dialogData.getText().isBlank();
        int numberOfButtons = dialogData.getNumberOfButtons();
        if (!hasText) {
            return DialogScreenLayout.UNKNOWN;
        }
        Object dialogText = dialogData.getDialogText();
        boolean hasDialogMacros = DialogUtils.hasDialogMacros((String)dialogText);
        if (TextFormattingCodes.hasTextLinebreakCodes((String)dialogText)) {
            dialogText = TextFormattingCodes.parseTextLineBreaks((String)dialogText);
        } else if (hasDialogMacros) {
            dialogText = (String)dialogText + "PLACEHOLDER_FOR_POSSIBLE_MACROS";
        }
        int numberOfLines = DialogUtils.getNumbersOfDialogLines((String)dialogText, font);
        int maxButtonNameLength = 0;
        if (numberOfButtons > 0) {
            for (DialogButtonData buttonData : dialogData.getButtons()) {
                int buttonNameLength = buttonData.getName().length();
                if (buttonNameLength <= maxButtonNameLength) continue;
                maxButtonNameLength = buttonNameLength;
            }
        }
        boolean bl = hasLargeButtonName = maxButtonNameLength > 20;
        if (numberOfLines <= 6) {
            if (numberOfButtons == 0) {
                return DialogScreenLayout.COMPACT_TEXT_ONLY;
            }
            if (numberOfButtons == 1) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON;
            }
            if (numberOfButtons == 2) {
                return hasLargeButtonName ? DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS : DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS;
            }
            if (numberOfButtons == 3) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS;
            }
            if (numberOfButtons == 4) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS;
            }
            if (numberOfButtons == 5) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS;
            }
            if (numberOfButtons == 6) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS;
            }
        }
        if (numberOfButtons == 0) {
            return DialogScreenLayout.TEXT_ONLY;
        }
        if (numberOfButtons == 1) {
            return DialogScreenLayout.TEXT_WITH_ONE_BUTTON;
        }
        if (numberOfButtons == 2) {
            return DialogScreenLayout.TEXT_WITH_TWO_BUTTONS;
        }
        if (numberOfButtons == 3) {
            return DialogScreenLayout.TEXT_WITH_THREE_BUTTONS;
        }
        if (numberOfButtons == 4) {
            return DialogScreenLayout.TEXT_WITH_FOUR_BUTTONS;
        }
        if (numberOfButtons == 5) {
            return DialogScreenLayout.TEXT_WITH_FIVE_BUTTONS;
        }
        if (numberOfButtons == 6) {
            return DialogScreenLayout.TEXT_WITH_SIX_BUTTONS;
        }
        return DialogScreenLayout.UNKNOWN;
    }
}

