/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import de.markusbordihn.easynpc.utils.UUIDUtils;
import java.util.UUID;
import net.minecraft.world.inventory.ContainerData;

public class ScreenContainerData
implements ContainerData {
    private static final int SYNCED_INDEX = 0;
    private static final int NPC_UUID_INDEX_START = 1;
    private static final int NPC_UUID_INDEX_END = 9;
    private static final int NPC_UUID_INDEX_SIZE = 8;
    private static final int DIALOG_UUID_INDEX_START = 10;
    private static final int DIALOG_UUID_INDEX_END = 18;
    private static final int DIALOG_UUID_INDEX_SIZE = 8;
    private static final int PAGE_INDEX = 19;
    private static final int SIZE = 20;
    private final short[] data = new short[20];

    public ScreenContainerData() {
        this(null);
        this.setSynced(false);
    }

    public ScreenContainerData(UUID npcUUID) {
        this(npcUUID, null, 0);
    }

    public ScreenContainerData(UUID npcUUID, UUID dialogUUID) {
        this(npcUUID, dialogUUID, 0);
    }

    public ScreenContainerData(UUID npcUUID, UUID dialogUUID, Integer pageIndex) {
        if (npcUUID != null) {
            this.setNpcUUID(npcUUID);
        }
        if (dialogUUID != null) {
            this.setDialogUUID(dialogUUID);
        }
        this.setPageIndex(pageIndex);
        this.setSynced(true);
    }

    public boolean isSynced() {
        return this.m_6413_(0) == 1;
    }

    public void setSynced(boolean synced) {
        this.m_8050_(0, synced ? 1 : 0);
    }

    public UUID getNpcUUID() {
        short[] uuidShorts = new short[8];
        System.arraycopy(this.data, 1, uuidShorts, 0, 8);
        return UUIDUtils.decodeShortToUUID(uuidShorts);
    }

    public void setNpcUUID(UUID uuid) {
        short[] uuidShorts = UUIDUtils.encodeUUIDToShort(uuid);
        System.arraycopy(uuidShorts, 0, this.data, 1, 8);
    }

    public UUID getDialogUUID() {
        short[] uuidShorts = new short[8];
        System.arraycopy(this.data, 10, uuidShorts, 0, 8);
        return UUIDUtils.decodeShortToUUID(uuidShorts);
    }

    public void setDialogUUID(UUID uuid) {
        short[] uuidShorts = UUIDUtils.encodeUUIDToShort(uuid);
        System.arraycopy(uuidShorts, 0, this.data, 10, 8);
    }

    public Integer getPageIndex() {
        return this.m_6413_(19);
    }

    public void setPageIndex(Integer pageIndex) {
        this.m_8050_(19, pageIndex);
    }

    public int m_6413_(int i) {
        return this.data[i];
    }

    public void m_8050_(int index, int value) {
        this.data[index] = (short)value;
    }

    public int m_6499_() {
        return this.data.length;
    }
}

