/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelPositionData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final EntityDataSerializer<CustomPosition> POSITION = new EntityDataSerializer<CustomPosition>(){

        public void write(FriendlyByteBuf buffer, CustomPosition position) {
            buffer.writeFloat(position.x());
            buffer.writeFloat(position.y());
            buffer.writeFloat(position.z());
        }

        public CustomPosition read(FriendlyByteBuf buffer) {
            return new CustomPosition(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public CustomPosition copy(CustomPosition position) {
            return position;
        }
    };
    public static final String EASY_NPC_DATA_MODEL_POSITION_TAG = "Position";
    public static final CustomPosition DEFAULT_MODEL_PART_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);

    public static void registerSyncedModelPositionData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Model Position Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_HEAD_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_BODY_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_ARMS_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, SynchedEntityData.m_135353_(entityClass, POSITION));
    }

    public static void registerModelPositionDataSerializer() {
        EntityDataSerializers.m_135050_(POSITION);
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    default public CustomPosition getModelPartPosition(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.getModelHeadPosition();
            case ModelPart.BODY -> this.getModelBodyPosition();
            case ModelPart.ARMS -> this.getModelArmsPosition();
            case ModelPart.LEFT_ARM -> this.getModelLeftArmPosition();
            case ModelPart.RIGHT_ARM -> this.getModelRightArmPosition();
            case ModelPart.LEFT_LEG -> this.getModelLeftLegPosition();
            case ModelPart.RIGHT_LEG -> this.getModelRightLegPosition();
            default -> DEFAULT_MODEL_PART_POSITION;
        };
    }

    default public CustomPosition getModelHeadPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_POSITION);
    }

    default public void setModelHeadPosition(CustomPosition modelHeadPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_POSITION, modelHeadPosition);
    }

    default public CustomPosition getModelBodyPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_POSITION);
    }

    default public void setModelBodyPosition(CustomPosition modelBodyPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_POSITION, modelBodyPosition);
    }

    default public CustomPosition getModelArmsPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_POSITION);
    }

    default public void setModelArmsPosition(CustomPosition modelArmsPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_POSITION, modelArmsPosition);
    }

    default public CustomPosition getModelLeftArmPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_POSITION);
    }

    default public void setModelLeftArmPosition(CustomPosition modelLeftArmPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_POSITION, modelLeftArmPosition);
    }

    default public CustomPosition getModelRightArmPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION);
    }

    default public void setModelRightArmPosition(CustomPosition modelRightArmPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, modelRightArmPosition);
    }

    default public CustomPosition getModelLeftLegPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_POSITION);
    }

    default public void setModelLeftLegPosition(CustomPosition modelLeftLegPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_POSITION, modelLeftLegPosition);
    }

    default public CustomPosition getModelRightLegPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION);
    }

    default public void setModelRightLegPosition(CustomPosition modelRightLegPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, modelRightLegPosition);
    }

    default public boolean hasChangedModelPosition() {
        return this.hasHeadModelPart() && this.getModelHeadPosition().hasChanged() || this.hasBodyModelPart() && this.getModelBodyPosition().hasChanged() || this.hasArmsModelPart() && this.getModelArmsPosition().hasChanged() || this.hasLeftArmModelPart() && this.getModelLeftArmPosition().hasChanged() || this.hasRightArmModelPart() && this.getModelRightArmPosition().hasChanged() || this.hasLeftLegModelPart() && this.getModelLeftLegPosition().hasChanged() || this.hasRightLegModelPart() && this.getModelRightLegPosition().hasChanged();
    }

    default public void defineSynchedModelPositionData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_HEAD_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_BODY_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ARMS_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
    }

    default public void addAdditionalModelPositionData(CompoundTag compoundTag) {
        CompoundTag positionsTag = new CompoundTag();
        if (this.hasHeadModelPart() && this.getModelHeadPosition() != null && this.getModelHeadPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.HEAD.getTagName(), (Tag)this.getModelHeadPosition().save());
        }
        if (this.hasBodyModelPart() && this.getModelBodyPosition() != null && this.getModelBodyPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.BODY.getTagName(), (Tag)this.getModelBodyPosition().save());
        }
        if (this.hasArmsModelPart() && this.getModelArmsPosition() != null && this.getModelArmsPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.ARMS.getTagName(), (Tag)this.getModelArmsPosition().save());
        }
        if (this.hasLeftArmModelPart() && this.getModelLeftArmPosition() != null && this.getModelLeftArmPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.LEFT_ARM.getTagName(), (Tag)this.getModelLeftArmPosition().save());
        }
        if (this.hasRightArmModelPart() && this.getModelRightArmPosition() != null && this.getModelRightArmPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.RIGHT_ARM.getTagName(), (Tag)this.getModelRightArmPosition().save());
        }
        if (this.hasLeftLegModelPart() && this.getModelLeftLegPosition() != null && this.getModelLeftLegPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.LEFT_LEG.getTagName(), (Tag)this.getModelLeftLegPosition().save());
        }
        if (this.hasRightLegModelPart() && this.getModelRightLegPosition() != null && this.getModelRightLegPosition().hasChanged()) {
            positionsTag.m_128365_(ModelPart.RIGHT_LEG.getTagName(), (Tag)this.getModelRightLegPosition().save());
        }
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_POSITION_TAG, (Tag)positionsTag);
    }

    default public void readAdditionalModelPositionData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_POSITION_TAG)) {
            return;
        }
        CompoundTag positionTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_POSITION_TAG);
        if (positionTag.m_128441_(ModelPart.HEAD.getTagName())) {
            this.setModelHeadPosition(new CustomPosition(positionTag.m_128437_(ModelPart.HEAD.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.BODY.getTagName())) {
            this.setModelBodyPosition(new CustomPosition(positionTag.m_128437_(ModelPart.BODY.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.ARMS.getTagName())) {
            this.setModelArmsPosition(new CustomPosition(positionTag.m_128437_(ModelPart.ARMS.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmPosition(new CustomPosition(positionTag.m_128437_(ModelPart.LEFT_ARM.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmPosition(new CustomPosition(positionTag.m_128437_(ModelPart.RIGHT_ARM.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegPosition(new CustomPosition(positionTag.m_128437_(ModelPart.LEFT_LEG.getTagName(), 5)));
        }
        if (positionTag.m_128441_(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegPosition(new CustomPosition(positionTag.m_128437_(ModelPart.RIGHT_LEG.getTagName(), 5)));
        }
    }
}

