/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public interface OwnerData<T extends PathfinderMob>
extends EasyNPC<T>,
OwnableEntity {
    public static final String DATA_OWNER_TAG = "Owner";

    public static void registerSyncedOwnerData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Owner Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.OWNER_UUID, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135041_));
    }

    default public UUID m_142504_() {
        Optional ownerUUID = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerUUID.orElse(null);
    }

    default public void setOwnerUUID(UUID uuid) {
        this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.ofNullable(uuid));
    }

    default public boolean hasOwner() {
        return this.m_142504_() != null;
    }

    default public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity != null && this.hasOwner() && livingEntity.m_142081_().equals(this.m_142504_());
    }

    default public LivingEntity getOwner() {
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.m_142504_();
            return uuid == null ? null : level.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public String getOwnerName() {
        LivingEntity owner = this.getOwner();
        return owner == null ? "" : owner.m_7755_().getString();
    }

    default public boolean isOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null && this.isOwner(serverPlayer.m_142081_());
    }

    default public boolean isOwner(UUID uuid) {
        return uuid != null && this.hasOwner() && uuid.equals(this.m_142504_());
    }

    default public void defineSynchedOwnerData() {
        this.defineSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(CompoundTag compoundTag) {
        if (this.m_142504_() != null) {
            compoundTag.m_128362_(DATA_OWNER_TAG, this.m_142504_());
        }
    }

    default public void readAdditionalOwnerData(CompoundTag compoundTag) {
        if (compoundTag.m_128403_(DATA_OWNER_TAG)) {
            UUID uuid = compoundTag.m_128342_(DATA_OWNER_TAG);
            this.setOwnerUUID(uuid);
        }
    }
}

