/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public interface TradingData<E extends PathfinderMob>
extends EasyNPC<E>,
Merchant {
    public static final EntityDataSerializer<TradingType> TRADING_TYPE = new EntityDataSerializer<TradingType>(){

        public void write(FriendlyByteBuf buffer, TradingType value) {
            buffer.m_130068_((Enum)value);
        }

        public TradingType read(FriendlyByteBuf buffer) {
            return (TradingType)buffer.m_130066_(TradingType.class);
        }

        public TradingType copy(TradingType value) {
            return value;
        }
    };
    public static final EntityDataSerializer<MerchantOffers> MERCHANT_OFFERS = new EntityDataSerializer<MerchantOffers>(){

        public void write(FriendlyByteBuf buffer, MerchantOffers value) {
            buffer.m_130079_(value.m_45388_());
        }

        public MerchantOffers read(FriendlyByteBuf buffer) {
            CompoundTag compoundTag = buffer.m_130260_();
            return compoundTag != null ? new MerchantOffers(compoundTag) : null;
        }

        public MerchantOffers copy(MerchantOffers value) {
            return value;
        }
    };
    public static final String DATA_TRADING_INVENTORY_TAG = "Inventory";
    public static final String DATA_TRADING_OFFERS_TAG = "Offers";
    public static final String DATA_TRADING_RECIPES_TAG = "Recipes";
    public static final String DATA_TRADING_TYPE_TAG = "TradingType";
    public static final String DATA_TRADING_RESETS_EVERY_MIN_TAG = "ResetsEveryMin";
    public static final String DATA_TRADING_BASIC_MAX_USES_TAG = "BasicMaxUses";
    public static final String DATA_TRADING_BASIC_REWARDED_XP_TAG = "BasicRewardedXP";

    public static void registerSyncedTradingData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Trading Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.TRADING_INVENTORY, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135042_));
        map.put(SynchedDataIndex.TRADING_MERCHANT_OFFERS, SynchedEntityData.m_135353_(entityClass, MERCHANT_OFFERS));
        map.put(SynchedDataIndex.TRADING_TYPE, SynchedEntityData.m_135353_(entityClass, TRADING_TYPE));
        map.put(SynchedDataIndex.TRADING_RESETS_EVERY_MIN, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135028_));
        map.put(SynchedDataIndex.TRADING_BASIC_MAX_USES, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135028_));
        map.put(SynchedDataIndex.TRADING_BASIC_REWARDED_XP, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135028_));
    }

    public static void registerTradingDataSerializer() {
        EntityDataSerializers.m_135050_(MERCHANT_OFFERS);
        EntityDataSerializers.m_135050_(TRADING_TYPE);
    }

    public void updateTradesData();

    public Player m_7962_();

    public void m_7189_(Player var1);

    public MerchantOffers m_6616_();

    default public void m_6255_(MerchantOffers merchantOffers) {
    }

    public void m_6996_(MerchantOffer var1);

    public void m_7713_(ItemStack var1);

    default public int m_7809_() {
        return 0;
    }

    default public void m_6621_(int experience) {
    }

    default public boolean m_7826_() {
        return true;
    }

    default public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    default public boolean m_183595_() {
        return this.getLevel() != null && this.getLevel().m_5776_();
    }

    default public void setAdvancedTradingOffers(Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        for (int tradingOffer = 0; tradingOffer < 25; ++tradingOffer) {
            MerchantOffer existingMerchantOffer;
            ItemStack itemA = container.m_8020_(tradingOffer * 3);
            ItemStack itemB = container.m_8020_(tradingOffer * 3 + 1);
            ItemStack itemResult = container.m_8020_(tradingOffer * 3 + 2);
            MerchantOffers existingMerchantOffers = this.getTradingOffers();
            MerchantOffer merchantOffer = existingMerchantOffer = existingMerchantOffers != null && existingMerchantOffers.size() > tradingOffer ? (MerchantOffer)existingMerchantOffers.get(tradingOffer) : null;
            if (existingMerchantOffer != null) {
                merchantOffers.add(tradingOffer, (Object)new MerchantOffer(itemA, itemB, itemResult, existingMerchantOffer.m_45371_(), existingMerchantOffer.m_45373_(), existingMerchantOffer.m_45379_(), existingMerchantOffer.m_45378_(), existingMerchantOffer.m_45375_()));
                continue;
            }
            merchantOffers.add(tradingOffer, (Object)new MerchantOffer(itemA, itemB, itemResult, 64, 1, 1.0f));
        }
        if (!merchantOffers.isEmpty()) {
            this.setTradingType(TradingType.ADVANCED);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void setBasicTradingOffers(Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            ItemStack itemA = container.m_8020_(tradingOffer * 3);
            ItemStack itemB = container.m_8020_(tradingOffer * 3 + 1);
            ItemStack itemResult = container.m_8020_(tradingOffer * 3 + 2);
            MerchantOffer merchantOffer = new MerchantOffer(itemA, itemB, itemResult, this.getBasicTradingMaxUses(), this.getBasicTradingRewardExp(), 1.0f);
            merchantOffers.add((Object)merchantOffer);
        }
        if (!merchantOffers.isEmpty()) {
            this.setTradingType(TradingType.BASIC);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void updateBasicTradingOffers() {
        if (this.getTradingType() != TradingType.BASIC) {
            return;
        }
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        MerchantOffers newMerchantOffers = new MerchantOffers();
        for (MerchantOffer merchantOffer : merchantOffers) {
            MerchantOffer newMerchantOffer = new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), this.getBasicTradingMaxUses(), this.getBasicTradingRewardExp(), merchantOffer.m_45378_());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        this.setTradingOffers(newMerchantOffers);
    }

    default public void resetTradingOffers() {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        for (MerchantOffer merchantOffer : merchantOffers) {
            merchantOffer.m_45372_();
        }
        this.setTradingOffers(merchantOffers);
    }

    default public MerchantOffers getTradingOffers() {
        return (MerchantOffers)this.getSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS);
    }

    default public void setTradingOffers(MerchantOffers merchantOffers) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, merchantOffers);
        this.updateTradesData();
    }

    default public CompoundTag getTradingInventory() {
        return (CompoundTag)this.getSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY);
    }

    default public void setTradingInventory(CompoundTag tradingInventory) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, tradingInventory);
    }

    default public TradingType getTradingType() {
        return (TradingType)((Object)this.getSynchedEntityData(SynchedDataIndex.TRADING_TYPE));
    }

    default public void setTradingType(TradingType tradingType) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_TYPE, tradingType);
    }

    default public boolean hasTrading() {
        return (this.getTradingType() == TradingType.BASIC || this.getTradingType() == TradingType.ADVANCED) && this.getTradingOffers() != null && !this.getTradingOffers().isEmpty() || this.getTradingType() == TradingType.CUSTOM;
    }

    default public void stopTrading() {
        Merchant merchant = this.getMerchant();
        if (merchant != null) {
            merchant.m_7189_(null);
        }
    }

    default public void setAdvancedTradingMaxUses(int tradingOfferIndex, int maxUses) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), 0, maxUses, merchantOffer.m_45379_(), merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingXp(int tradingOfferIndex, int xp) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), xp, merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingPriceMultiplier(int tradingOfferIndex, float priceMultiplier) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), priceMultiplier, merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingDemand(int tradingOfferIndex, int demand) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), merchantOffer.m_45378_(), demand));
        this.setTradingOffers(merchantOffers);
    }

    default public int getBasicTradingMaxUses() {
        return (Integer)this.getSynchedEntityData(SynchedDataIndex.TRADING_BASIC_MAX_USES);
    }

    default public void setBasicTradingMaxUses(int maxUses) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_BASIC_MAX_USES, maxUses);
    }

    default public int getBasicTradingRewardExp() {
        return (Integer)this.getSynchedEntityData(SynchedDataIndex.TRADING_BASIC_REWARDED_XP);
    }

    default public void setBasicTradingRewardExp(int rewardExp) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_BASIC_REWARDED_XP, rewardExp);
    }

    default public int getTradingResetsEveryMin() {
        return (Integer)this.getSynchedEntityData(SynchedDataIndex.TRADING_RESETS_EVERY_MIN);
    }

    default public void setTradingResetsEveryMin(int resetsEveryMin) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_RESETS_EVERY_MIN, resetsEveryMin);
    }

    default public InteractionResult openTradingScreen(ServerPlayer serverPlayer) {
        if (!this.m_183595_()) {
            Merchant merchant = this.getMerchant();
            if (merchant == null) {
                log.error("No merchant found for {} with {} from {}", (Object)this, (Object)this.getTradingOffers(), (Object)serverPlayer);
                return InteractionResult.PASS;
            }
            if (merchant.m_7962_() != null && merchant.m_7962_() != serverPlayer) {
                log.warn("Unable to open trading screen for {} with {} from {}, {} is still trading.", (Object)this, (Object)merchant.m_6616_(), (Object)serverPlayer, (Object)merchant.m_7962_());
                serverPlayer.m_6352_((Component)new TranslatableComponent("text.easy_npc.trading.busy", new Object[]{merchant.m_7962_()}), this.getUUID());
                return InteractionResult.PASS;
            }
            log.debug("Open trading screen for {} with {} from {}", (Object)this, (Object)merchant.m_6616_(), (Object)serverPlayer);
            merchant.m_7189_((Player)serverPlayer);
            merchant.m_45301_((Player)serverPlayer, (Component)(this.getEntity().m_7770_() != null ? this.getEntity().m_7770_() : new TranslatableComponent("text.easy_npc.trading")), 140);
        }
        return InteractionResult.m_19078_((boolean)this.m_183595_());
    }

    default public void defineSynchedTradingData() {
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, new CompoundTag());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_TYPE, TradingType.NONE);
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_RESETS_EVERY_MIN, 0);
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_BASIC_MAX_USES, 64);
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_BASIC_REWARDED_XP, 1);
    }

    default public void addAdditionalTradingData(CompoundTag compoundTag) {
        CompoundTag tradingTag = new CompoundTag();
        tradingTag.m_128365_(DATA_TRADING_INVENTORY_TAG, (Tag)this.getTradingInventory());
        tradingTag.m_128365_(DATA_TRADING_RECIPES_TAG, (Tag)this.getTradingOffers().m_45388_());
        tradingTag.m_128359_(DATA_TRADING_TYPE_TAG, this.getTradingType().name());
        tradingTag.m_128405_(DATA_TRADING_RESETS_EVERY_MIN_TAG, this.getTradingResetsEveryMin());
        tradingTag.m_128405_(DATA_TRADING_BASIC_MAX_USES_TAG, this.getBasicTradingMaxUses());
        tradingTag.m_128405_(DATA_TRADING_BASIC_REWARDED_XP_TAG, this.getBasicTradingRewardExp());
        compoundTag.m_128365_(DATA_TRADING_OFFERS_TAG, (Tag)tradingTag);
    }

    default public void readAdditionalTradingData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_TRADING_OFFERS_TAG)) {
            return;
        }
        CompoundTag tradingTag = compoundTag.m_128469_(DATA_TRADING_OFFERS_TAG);
        String tradingType = tradingTag.m_128461_(DATA_TRADING_TYPE_TAG);
        if (!tradingType.isEmpty()) {
            this.setTradingType(TradingType.get(tradingType));
        }
        if (tradingTag.m_128441_(DATA_TRADING_RESETS_EVERY_MIN_TAG)) {
            this.setTradingResetsEveryMin(tradingTag.m_128451_(DATA_TRADING_RESETS_EVERY_MIN_TAG));
        }
        if (tradingTag.m_128441_(DATA_TRADING_BASIC_MAX_USES_TAG)) {
            this.setBasicTradingMaxUses(tradingTag.m_128451_(DATA_TRADING_BASIC_MAX_USES_TAG));
        }
        if (tradingTag.m_128441_(DATA_TRADING_BASIC_REWARDED_XP_TAG)) {
            this.setBasicTradingRewardExp(tradingTag.m_128451_(DATA_TRADING_BASIC_REWARDED_XP_TAG));
        }
        if (tradingTag.m_128441_(DATA_TRADING_RECIPES_TAG)) {
            MerchantOffers merchantOffers = new MerchantOffers(tradingTag.m_128469_(DATA_TRADING_RECIPES_TAG));
            if (!merchantOffers.isEmpty()) {
                this.setTradingOffers(merchantOffers);
            }
            return;
        }
        if (tradingTag.m_128441_(DATA_TRADING_INVENTORY_TAG)) {
            this.setTradingInventory(tradingTag.m_128469_(DATA_TRADING_INVENTORY_TAG));
        }
    }
}

