/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionGroup;
import de.markusbordihn.easynpc.data.action.ActionManager;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;

public interface ActionHandler<E extends PathfinderMob>
extends EasyNPC<E> {
    private static boolean validateActionData(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        return actionDataEntry != null && serverPlayer != null && actionDataEntry.isValidAndNotEmpty() && !serverPlayer.m_183503_().m_5776_();
    }

    public static void executeEntityCommand(String command, Entity entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = entity.m_20194_();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for entity {}", (Object)entity);
            return;
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_(entity).m_81348_(entity.m_20182_()).m_81346_(entity.m_20155_()).m_81325_(permissionLevel);
        commands.m_82117_(debug ? commandSourceStack : commandSourceStack.m_81324_(), command);
    }

    public static void executePlayerCommand(String command, ServerPlayer serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = serverPlayer.m_20194_();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for player {}", (Object)serverPlayer);
            return;
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_((Entity)serverPlayer).m_81348_(serverPlayer.m_20182_()).m_81346_(serverPlayer.m_20155_()).m_81325_(permissionLevel).m_81327_(serverPlayer.m_183503_());
        commands.m_82117_(debug ? commandSourceStack : commandSourceStack.m_81324_(), command);
    }

    default public List<? extends Player> getPlayersInRange(Double range) {
        Entity entity = this.getEntity();
        return this.getLevel().m_6907_().stream().filter(EntitySelector.f_20408_).filter(targetPlayers -> entity.m_19950_((Entity)targetPlayers, range.doubleValue())).toList();
    }

    default public void checkTradingActions() {
        this.getProfiler().m_6180_("npcCheckTradingActions");
        TradingData tradingData = this.getEasyNPCTradingData();
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tradingData == null || tickerData == null) {
            return;
        }
        if ((tradingData.getTradingType() == TradingType.BASIC || tradingData.getTradingType() == TradingType.ADVANCED) && tradingData.getTradingResetsEveryMin() > 0 && tickerData.checkAndIncreaseTicker(TickerType.TRADING_RESET, tradingData.getTradingResetsEveryMin())) {
            tradingData.resetTradingOffers();
            tickerData.resetTicker(TickerType.TRADING_RESET);
        }
        this.getProfiler().m_7238_();
    }

    default public void checkDistanceActions() {
        ServerPlayer serverPlayer;
        ActionDataEntry actionDataEntry;
        List<Player> listOfPlayers;
        this.getProfiler().m_6180_("npcCheckDistanceActions");
        Mob mob = this.getMob();
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null || mob == null || mob.m_21224_()) {
            return;
        }
        boolean skipPlayerDistanceCheck = false;
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_NEAR)) {
            listOfPlayers = this.getPlayersInRange(16.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_NEAR);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_NEAR);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(8.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(4.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_VERY_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_TOUCH)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(1.25);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_TOUCH);
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_TOUCH);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer);
                }
            }
        }
        this.getProfiler().m_7238_();
    }

    default public void executeActions(Set<ActionDataEntry> actionDataEntrySet, ServerPlayer serverPlayer) {
        if (actionDataEntrySet == null || actionDataEntrySet.isEmpty()) {
            return;
        }
        for (ActionDataEntry actionDataEntry : actionDataEntrySet) {
            this.executeAction(actionDataEntry, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.executeAction(actionDataEntry, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        switch (actionDataEntry.getType()) {
            case NONE: {
                break;
            }
            case COMMAND: {
                if (actionDataEntry.shouldExecuteAsUser()) {
                    this.executePlayerCommand(actionDataEntry, serverPlayer);
                    break;
                }
                this.executeEntityCommand(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_NAMED_DIALOG: {
                this.openNamedDialog(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_TRADING_SCREEN: {
                TradingData tradingData = this.getEasyNPCTradingData();
                if (tradingData != null) {
                    tradingData.openTradingScreen(serverPlayer);
                    break;
                }
                log.error("No trading data found for action {}", (Object)actionDataEntry);
                break;
            }
            default: {
                log.warn("Unknown action type {} for action {}", (Object)actionDataEntry.getType(), (Object)actionDataEntry);
            }
        }
    }

    default public void openNamedDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        String dialogLabel = actionDataEntry.getCommand();
        DialogData dialogData = this.getEasyNPCDialogData();
        if (dialogLabel != null && !dialogLabel.isEmpty() && dialogData != null && dialogData.hasDialog(dialogLabel)) {
            UUID dialogId = dialogData.getDialogId(dialogLabel);
            dialogData.openDialogMenu(serverPlayer, this, dialogId, 0);
        } else {
            log.error("Unknown dialog label {} for action {}", (Object)dialogLabel, (Object)actionDataEntry);
        }
    }

    default public void executePlayerCommand(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int userPermissionLevel = actionDataEntry.getPermissionLevel();
        if (userPermissionLevel > actionEventData.getActionPermissionLevel()) {
            log.warn("User permission level {} is lower than action permission level {} for action {}", (Object)actionEventData.getActionPermissionLevel(), (Object)userPermissionLevel, (Object)actionDataEntry);
            userPermissionLevel = actionEventData.getActionPermissionLevel();
        }
        log.debug("Try to execute action {} as user {} with user permission level {} of requested action permission level {} ...", (Object)actionDataEntry, (Object)serverPlayer, (Object)userPermissionLevel, (Object)actionDataEntry.getPermissionLevel());
        ActionHandler.executePlayerCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), serverPlayer, userPermissionLevel, actionDataEntry.isDebugEnabled());
    }

    default public void executeEntityCommand(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int ownerPermissionLevel = actionEventData.getActionPermissionLevel();
        if (ownerPermissionLevel > 3) {
            ownerPermissionLevel = 3;
        } else if (ownerPermissionLevel <= 0) {
            ownerPermissionLevel = 1;
        }
        log.debug("Try to execute action {} as entity {} with owner permission level {} of max. {} ...", (Object)actionDataEntry, (Object)this.getEntity(), (Object)ownerPermissionLevel, (Object)actionEventData.getActionPermissionLevel());
        ActionHandler.executeEntityCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), this.getEntity(), ownerPermissionLevel, actionDataEntry.isDebugEnabled());
    }
}

