/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class ZombieVillager
extends EasyNPCBaseModelEntity<ZombieVillager> {
    public static final String ID = "zombie_villager";

    public ZombieVillager(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.DEFAULT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.ZOMBIE_VILLAGER;
    }

    @Override
    public Component m_7755_() {
        Component component = this.m_7770_();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getVariantName();
        return new TextComponent(variantName.getString() + " (" + professionName.getString() + ")");
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public boolean hasProfession() {
        return true;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.DEFAULT;
    }

    @Override
    public Enum<?> getVariant(String name) {
        return Variant.valueOf(name);
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12615_);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12646_);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12645_);
        soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12647_);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static enum Variant {
        DEFAULT,
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

    }
}

