/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private AttributeHandler() {
    }

    public static boolean setEntityAttribute(EasyNPC<?> easyNPC, EntityAttribute entityAttribute, boolean value) {
        if (easyNPC == null || entityAttribute == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
            switch (entityAttribute) {
                case FREEFALL: {
                    log.debug("Change freefall={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeFreefall(value);
                    break;
                }
                case CAN_BE_LEASHED: {
                    log.debug("Change canBeLeashed={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanBeLeashed(value);
                    break;
                }
                case CAN_FLOAT: {
                    log.debug("Change canFloat={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanFloat(value);
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_OPEN_DOOR: {
                    log.debug("Change canOpenDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanOpenDoor(value);
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_CLOSE_DOOR: {
                    log.debug("Change canCloseDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanCloseDoor(value);
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_PASS_DOOR: {
                    log.debug("Change canPassDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanPassDoor(value);
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_USE_NETHER_PORTAL: {
                    log.debug("Change canUseNetherPortal={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanUseNetherPortal(value);
                    break;
                }
                case IS_ATTACKABLE: {
                    log.debug("Change isAttackable={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeIsAttackable(value);
                    if (easyNPC.getLivingEntity() == null) break;
                    easyNPC.getLivingEntity().m_20331_(!value);
                    break;
                }
                case IS_PUSHABLE: {
                    log.debug("Change isPushable={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeIsPushable(value);
                    break;
                }
                case PUSH_ENTITIES: {
                    log.debug("Change pushEntities={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributePushEntities(value);
                    break;
                }
                case SILENT: {
                    log.debug("Change silent={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeSilent(value);
                    break;
                }
                default: {
                    log.error("Unimplemented entity attribute {} for {}", (Object)entityAttribute, easyNPC);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean setEntityAttribute(EasyNPC<?> easyNPC, EntityAttribute entityAttribute, Integer value) {
        if (easyNPC == null || entityAttribute == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            switch (entityAttribute) {
                case LIGHT_LEVEL: {
                    log.debug("Change lightLevel={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeLightLevel(value);
                    break;
                }
                default: {
                    log.error("Unimplemented entity attribute {} for {}", (Object)entityAttribute, easyNPC);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean setBaseAttribute(EasyNPC<?> easyNPC, ResourceLocation attribute, Double value) {
        if (easyNPC == null || attribute == null || value == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            switch (attribute.toString()) {
                case "minecraft:generic.max_health": {
                    attributeData.setBaseAttribute(Attributes.f_22276_, value);
                    LivingEntity livingEntity = easyNPC.getLivingEntity();
                    if (livingEntity == null) break;
                    livingEntity.m_21153_(value.floatValue());
                    break;
                }
                case "minecraft:generic.follow_range": {
                    attributeData.setBaseAttribute(Attributes.f_22277_, value);
                    break;
                }
                case "minecraft:generic.knockback_resistance": {
                    attributeData.setBaseAttribute(Attributes.f_22278_, value);
                    break;
                }
                case "minecraft:generic.movement_speed": {
                    attributeData.setBaseAttribute(Attributes.f_22279_, value);
                    break;
                }
                case "minecraft:generic.flying_speed": {
                    attributeData.setBaseAttribute(Attributes.f_22280_, value);
                    break;
                }
                case "minecraft:generic.attack_damage": {
                    attributeData.setBaseAttribute(Attributes.f_22281_, value);
                    break;
                }
                case "minecraft:generic.attack_knockback": {
                    attributeData.setBaseAttribute(Attributes.f_22282_, value);
                    break;
                }
                case "minecraft:generic.attack_speed": {
                    attributeData.setBaseAttribute(Attributes.f_22283_, value);
                    break;
                }
                case "minecraft:generic.armor": {
                    attributeData.setBaseAttribute(Attributes.f_22284_, value);
                    break;
                }
                case "minecraft:generic.armor_toughness": {
                    attributeData.setBaseAttribute(Attributes.f_22285_, value);
                    break;
                }
                case "minecraft:generic.luck": {
                    attributeData.setBaseAttribute(Attributes.f_22286_, value);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Attribute getAttribute(ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        return Registry.f_122866_.m_6612_(resourceLocation).orElse(null);
    }
}

