/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomSkinDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String DATA_FOLDER_NAME = "skin";

    private CustomSkinDataFiles() {
    }

    public static void registerCustomSkinData() {
        log.info("{} custom skin data ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
            if (skinModelFolder == null) continue;
            String skinModelName = skinModel.getName();
            ResourceLocation resourceLocation = new ResourceLocation("easy_npc", "textures/entity/" + skinModelName + "/" + skinModelName + "_template.png");
            File skinModelTemplateFile = skinModelFolder.resolve(skinModelName + "_template.png").toFile();
            if (skinModelTemplateFile.exists()) {
                log.warn("Skin model template file {} already exists, skipping copy!", (Object)skinModelTemplateFile);
                continue;
            }
            log.info("Copy skin model template file {} to {} ...", (Object)resourceLocation, (Object)skinModelTemplateFile);
            DataFileHandler.copyResourceFile(resourceLocation, skinModelTemplateFile);
        }
        CustomSkinDataFiles.registerTextureFiles();
    }

    public static void registerTextureFiles() {
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        log.info("{} custom skins from {} ...", (Object)"\ud83d\udde3 Register Easy NPC", (Object)skinDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
            if (skinModelFolder == null || !skinModelFolder.toFile().exists() || !skinModelFolder.toFile().isDirectory()) continue;
            for (String skinFileName : skinModelFolder.toFile().list()) {
                Path skinFilePath = skinModelFolder.resolve(skinFileName);
                File skinFile = skinFilePath.toFile();
                if (!skinFile.exists() || !skinFileName.endsWith(".png")) continue;
                CustomTextureManager.registerTexture(skinModel, skinFile);
            }
        }
    }

    public static void refreshRegisterTextureFiles() {
        CustomTextureManager.clearTextureCache();
        CustomSkinDataFiles.registerTextureFiles();
    }

    public static Path getCustomSkinDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getCustomSkinDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path skinDataFolderPath = skinDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(skinDataFolderPath, new LinkOption[0]) && Files.isDirectory(skinDataFolderPath, new LinkOption[0])) {
                return skinDataFolderPath;
            }
            log.info("Created new skin data folder {} at {}!", (Object)skinModelName, (Object)skinDataFolderPath);
            return Files.createDirectories(skinDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Could not create skin data folder {} at {}!", (Object)skinModelName, (Object)skinDataFolder.resolve(skinModelName));
            return null;
        }
    }
}

