/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataFileHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String CACHE_FOLDER_NAME = "cache";

    private DataFileHandler() {
    }

    public static void registerDataFiles() {
        log.info("{} general data folders ...", (Object)"\ud83d\udde3 Register Easy NPC");
        DataFileHandler.getCacheFolder();
        DataFileHandler.getCustomDataFolder();
        log.info("{} skin data folders ...", (Object)"\ud83d\udde3 Register Easy NPC");
        CustomSkinDataFiles.registerCustomSkinData();
        PlayerSkinDataFiles.registerPlayerSkinData();
        RemoteSkinDataFiles.registerRemoteSkinData();
        log.info("{} preset data folders ...", (Object)"\ud83d\udde3 Register Easy NPC");
        CustomPresetDataFiles.registerCustomPresetData();
    }

    public static Path getCacheFolder() {
        Path cacheFolder = Constants.GAME_DIR.resolve("easy_npc").resolve(CACHE_FOLDER_NAME);
        try {
            if (Files.exists(cacheFolder, new LinkOption[0]) && Files.isDirectory(cacheFolder, new LinkOption[0])) {
                return cacheFolder;
            }
            log.info("Creating cache folder at {} ...", (Object)cacheFolder);
            return Files.createDirectories(cacheFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getCustomDataFolder() {
        Path customDataFolder = Constants.CONFIG_DIR.resolve("easy_npc");
        try {
            if (Files.exists(customDataFolder, new LinkOption[0]) && Files.isDirectory(customDataFolder, new LinkOption[0])) {
                return customDataFolder;
            }
            log.info("Creating custom data folder at {} ...", (Object)customDataFolder);
            return Files.createDirectories(customDataFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getOrCreateCacheFolder(String dataLabel) {
        Path cacheFolder = DataFileHandler.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        Path cacheFolderPath = cacheFolder.resolve(dataLabel);
        try {
            if (Files.exists(cacheFolderPath, new LinkOption[0]) && Files.isDirectory(cacheFolderPath, new LinkOption[0])) {
                return cacheFolderPath;
            }
            log.info("Creating cache folder {} at {} ...", (Object)dataLabel, (Object)cacheFolder);
            return Files.createDirectories(cacheFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static Path getOrCreateCustomDataFolder(String dataLabel) {
        Path customDataFolder = DataFileHandler.getCustomDataFolder();
        if (customDataFolder == null) {
            return null;
        }
        Path customDataFolderPath = customDataFolder.resolve(dataLabel);
        try {
            if (Files.exists(customDataFolderPath, new LinkOption[0]) && Files.isDirectory(customDataFolderPath, new LinkOption[0])) {
                return customDataFolderPath;
            }
            log.info("Creating custom data folder {} at {} ...", (Object)dataLabel, (Object)customDataFolder);
            return Files.createDirectories(customDataFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static void copyResourceFile(ResourceLocation resourceLocation, File targetFile) {
        if (resourceLocation == null || targetFile == null) {
            return;
        }
        try {
            InputStream inputStream = Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation).m_6679_();
            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to load resource {}!", (Object)resourceLocation, (Object)e);
        }
    }
}

