/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration.attribute;

import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.menu.configuration.attribute.AttributeConfigurationMenu;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class BaseAttributeConfigurationMenu
extends AttributeConfigurationMenu {
    private final double followRange;
    private final double knockbackResistance;
    private final double attackDamage;
    private final double attackKnockback;

    public BaseAttributeConfigurationMenu(int windowId, Inventory playerInventory, UUID uuid, double followRange, double knockbackResistance, double attackDamage, double attackKnockback) {
        super((MenuType)ModMenuTypes.BASE_ATTRIBUTE_CONFIGURATION_MENU.get(), windowId, playerInventory, uuid);
        this.followRange = followRange;
        this.knockbackResistance = knockbackResistance;
        this.attackDamage = attackDamage;
        this.attackKnockback = attackKnockback;
    }

    public BaseAttributeConfigurationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_(), data.readDouble(), data.readDouble(), data.readDouble(), data.readDouble());
    }

    public static MenuProvider getMenuProvider(final UUID uuid, final LivingEntity entity) {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Base Attribute for " + entity.m_7755_().getString());
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                double followRangeValue = entity.m_21051_(Attributes.f_22277_) != null ? entity.m_21051_(Attributes.f_22277_).m_22115_() : 32.0;
                double knockbackResistanceValue = entity.m_21051_(Attributes.f_22278_) != null ? entity.m_21051_(Attributes.f_22278_).m_22115_() : 0.0;
                double attackDamageValue = entity.m_21051_(Attributes.f_22281_) != null ? entity.m_21051_(Attributes.f_22281_).m_22115_() : 2.0;
                double attackKnockbackValue = entity.m_21051_(Attributes.f_22282_) != null ? entity.m_21051_(Attributes.f_22282_).m_22115_() : 0.0;
                return new BaseAttributeConfigurationMenu(windowId, inventory, uuid, followRangeValue, knockbackResistanceValue, attackDamageValue, attackKnockbackValue);
            }
        };
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }
}

