/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.editor;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogButtonEditorMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final DialogDataSet dialogDataSet;
    protected final DialogButtonData dialogButtonData;
    protected final Inventory playerInventory;
    protected final EasyNPC<?> easyNPC;
    protected final UUID dialogId;
    protected final UUID uuid;
    protected final UUID dialogButtonId;
    protected final ConfigurationType formerConfigurationType;
    protected final int pageIndex;

    public DialogButtonEditorMenu(int windowId, Inventory playerInventory, UUID uuid, DialogDataSet dialogDataSet, UUID dialogId, UUID dialogButtonId, ConfigurationType formerConfigurationType, int pageIndex) {
        this((MenuType)ModMenuTypes.DIALOG_BUTTON_EDITOR_MENU.get(), windowId, playerInventory, uuid, dialogDataSet, dialogId, dialogButtonId, formerConfigurationType, pageIndex);
    }

    public DialogButtonEditorMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_(), new DialogDataSet(data.m_130260_()), data.m_130259_(), data.m_130259_(), (ConfigurationType)data.m_130066_(ConfigurationType.class), data.readInt());
    }

    public DialogButtonEditorMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, UUID uuid, DialogDataSet dialogDataSet, UUID dialogId, UUID dialogButtonId, ConfigurationType formerConfigurationType, int pageIndex) {
        super(menuType, windowId);
        this.playerInventory = playerInventory;
        this.dialogDataSet = dialogDataSet;
        this.dialogButtonData = dialogDataSet.getDialog(dialogId).getButton(dialogButtonId);
        this.dialogButtonId = dialogButtonId;
        this.uuid = uuid;
        this.dialogId = dialogId;
        this.formerConfigurationType = formerConfigurationType;
        this.pageIndex = pageIndex;
        this.easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid);
    }

    public static MenuProvider getMenuProvider(final UUID uuid, Entity entity, final DialogDataSet dialogDataSet, final UUID dialogId, final UUID dialogButtonId, final ConfigurationType formerConfigurationType, final int pageIndex) {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Edit Dialog Button " + dialogButtonId);
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                return new DialogButtonEditorMenu(windowId, inventory, uuid, dialogDataSet, dialogId, dialogButtonId, formerConfigurationType, pageIndex);
            }
        };
    }

    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    public DialogButtonData getDialogButtonData() {
        return this.dialogButtonData;
    }

    public EasyNPC<?> getEasyNPC() {
        return this.easyNPC;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public UUID getDialogButtonId() {
        return this.dialogButtonId;
    }

    public ConfigurationType getFormerConfigurationType() {
        return this.formerConfigurationType;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_() && this.easyNPC != null && this.easyNPC.getEntity().m_6084_();
    }
}

