/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.cache.CacheType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ClientNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public void exportClientPreset(UUID var1, String var2, ServerPlayer var3);

    public void syncCacheData(UUID var1, ServerPlayer var2, CacheType var3, CompoundTag var4);

    default public void syncActionEventSet(UUID uuid, ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC != null && easyNPC.getEasyNPCActionEventData() != null) {
            this.syncCacheData(uuid, serverPlayer, CacheType.ACTION_DATA_SET, easyNPC.getEasyNPCActionEventData().getActionEventSet().createTag());
        } else {
            log.error("Failed to sync action event set for entity with UUID {}", (Object)uuid);
        }
    }

    default public void syncDialogDataSet(UUID uuid, ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC != null && easyNPC.getEasyNPCDialogData() != null) {
            this.syncCacheData(uuid, serverPlayer, CacheType.DIALOG_DATA_SET, easyNPC.getEasyNPCDialogData().getDialogDataSet().createTag());
        } else {
            log.error("Failed to sync dialog data set for entity with UUID {}", (Object)uuid);
        }
    }

    default public void syncObjectiveDataSet(UUID uuid, ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC != null && easyNPC.getEasyNPCObjectiveData() != null) {
            this.syncCacheData(uuid, serverPlayer, CacheType.OBJECTIVE_DATA_SET, easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet().createTag());
        } else {
            log.error("Failed to sync objective data set for entity with UUID {}", (Object)uuid);
        }
    }

    default public void syncCustomPresets(ServerPlayer serverPlayer) {
        Set<ResourceLocation> customPresets = CustomPresetDataFiles.getPresetResourceLocations().collect(Collectors.toSet());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("customPresets", (Tag)CompoundTagUtils.writeResourceLocations(customPresets));
        this.syncCacheData(Constants.EMPTY_UUID, serverPlayer, CacheType.CUSTOM_PRESETS, compoundTag);
    }

    default public void syncDefaultPresets(ServerPlayer serverPlayer) {
        Set<ResourceLocation> defaultPresets = DefaultPresetDataFiles.getPresetResourceLocations(serverPlayer.m_20194_()).collect(Collectors.toSet());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("defaultPresets", (Tag)CompoundTagUtils.writeResourceLocations(defaultPresets));
        this.syncCacheData(Constants.EMPTY_UUID, serverPlayer, CacheType.DEFAULT_PRESETS, compoundTag);
    }

    default public void syncWorldPresets(ServerPlayer serverPlayer) {
        Set<ResourceLocation> worldPresets = WorldPresetDataFiles.getPresetResourceLocations().collect(Collectors.toSet());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("worldPresets", (Tag)CompoundTagUtils.writeResourceLocations(worldPresets));
        this.syncCacheData(Constants.EMPTY_UUID, serverPlayer, CacheType.WORLD_PRESETS, compoundTag);
    }
}

