/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.block.entity.BaseEasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeSpawnerSettingMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_spawner_settings");
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private final BlockPos spawnerPos;
    private final SpawnerSettingType settingType;
    private final int value;

    public ChangeSpawnerSettingMessage(BlockPos blockPos, SpawnerSettingType settingType, int value) {
        this.spawnerPos = blockPos;
        this.settingType = settingType;
        this.value = value;
    }

    public static ChangeSpawnerSettingMessage decode(FriendlyByteBuf buffer) {
        return new ChangeSpawnerSettingMessage(buffer.m_130135_(), (SpawnerSettingType)buffer.m_130066_(SpawnerSettingType.class), buffer.readInt());
    }

    public static FriendlyByteBuf encode(ChangeSpawnerSettingMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.getSpawnerPos());
        buffer.m_130068_((Enum)message.getSettingType());
        buffer.writeInt(message.getValue());
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        ChangeSpawnerSettingMessage.handle(ChangeSpawnerSettingMessage.decode(buffer), serverPlayer);
    }

    public static void handle(ChangeSpawnerSettingMessage message, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        ServerLevel serverLevel = serverPlayer.m_183503_();
        BlockEntity blockEntity = serverLevel.m_7702_(message.getSpawnerPos());
        if (blockEntity == null) {
            blockEntity = serverLevel.m_46745_(message.getSpawnerPos()).m_5685_(message.getSpawnerPos(), LevelChunk.EntityCreationType.IMMEDIATE);
        }
        if (!(blockEntity instanceof BaseEasyNPCSpawnerBlockEntity)) {
            log.error("Found {}({}) instead of NPC spawner block entity at {}", (Object)blockEntity, (Object)serverLevel.m_8055_(message.getSpawnerPos()), (Object)message.getSpawnerPos());
            return;
        }
        BaseEasyNPCSpawnerBlockEntity spawnerBlockEntity = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
        if (!serverPlayer.m_7500_() && spawnerBlockEntity.getOwner() != null && !spawnerBlockEntity.getOwner().equals(serverPlayer.m_142081_())) {
            log.warn("Player {} has no permission to change the settings of spawner at {}", (Object)serverPlayer.m_7755_().getString(), (Object)message.getSpawnerPos());
            return;
        }
        switch (message.getSettingType()) {
            case SPAWN_RANGE: {
                log.debug("Set spawner {} spawn range to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setSpawnRange(message.getValue());
                break;
            }
            case DESPAWN_RANGE: {
                log.debug("Set spawner {} despawn range to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setDespawnRange(message.getValue());
                break;
            }
            case REQUIRED_PLAYER_RANGE: {
                log.debug("Set spawner {} required player range to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setRequiredPlayerRange(message.getValue());
                break;
            }
            case DELAY: {
                log.debug("Set spawner {} delay to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setDelay(message.getValue());
                break;
            }
            case MAX_NEARBY_ENTITIES: {
                log.debug("Set spawner {} max nearby entities to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setMaxNearbyEntities(message.getValue());
                break;
            }
            case SPAWN_COUNT: {
                log.debug("Set spawner {} spawn count to {}", (Object)spawnerBlockEntity, (Object)message.getValue());
                spawnerBlockEntity.setSpawnCount(message.getValue());
                break;
            }
            default: {
                log.error("Unknown spawner setting type {} for {}", (Object)message.getSettingType(), (Object)spawnerBlockEntity);
            }
        }
    }

    public FriendlyByteBuf encode() {
        return ChangeSpawnerSettingMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public BlockPos getSpawnerPos() {
        return this.spawnerPos;
    }

    public SpawnerSettingType getSettingType() {
        return this.settingType;
    }

    public int getValue() {
        return this.value;
    }
}

