/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ImportPresetMessage
extends NetworkMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "import_preset");
    protected final CompoundTag compoundTag;
    protected final ResourceLocation resourceLocation;
    protected final PresetType presetType;

    public ImportPresetMessage(UUID uuid, PresetType presetType, CompoundTag compoundTag) {
        super(uuid);
        this.presetType = presetType;
        this.compoundTag = compoundTag;
        this.resourceLocation = null;
    }

    public ImportPresetMessage(UUID uuid, PresetType presetType, ResourceLocation resourceLocation) {
        super(uuid);
        this.presetType = presetType;
        this.compoundTag = null;
        this.resourceLocation = resourceLocation;
    }

    public static ImportPresetMessage decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        PresetType presetType = (PresetType)buffer.m_130066_(PresetType.class);
        if (presetType == PresetType.LOCAL) {
            CompoundTag compoundTag = buffer.m_130260_();
            return new ImportPresetMessage(uuid, presetType, compoundTag);
        }
        ResourceLocation resourceLocation = buffer.m_130281_();
        return new ImportPresetMessage(uuid, presetType, resourceLocation);
    }

    public static FriendlyByteBuf encode(ImportPresetMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.presetType);
        if (message.presetType == PresetType.LOCAL) {
            buffer.m_130079_(message.compoundTag);
        } else {
            buffer.m_130085_(message.resourceLocation);
        }
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        ImportPresetMessage.handle(ImportPresetMessage.decode(buffer), serverPlayer);
    }

    public static void handle(ImportPresetMessage message, ServerPlayer serverPlayer) {
        UUID uuid = message.getUUID();
        if (!NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        switch (message.getPresetType()) {
            case LOCAL: {
                PresetHandler.importPreset(serverPlayer.m_183503_(), message.getCompoundTag(), null, uuid);
                break;
            }
            case CUSTOM: {
                PresetHandler.importCustomPreset(serverPlayer.m_183503_(), message.getResourceLocation(), easyNPC.getEntity().m_20182_(), uuid);
                break;
            }
            case DATA: {
                PresetHandler.importDataPreset(serverPlayer.m_183503_(), message.getResourceLocation(), easyNPC.getEntity().m_20182_(), uuid);
                break;
            }
            case DEFAULT: {
                PresetHandler.importDefaultPreset(serverPlayer.m_183503_(), message.getResourceLocation(), easyNPC.getEntity().m_20182_(), uuid);
                break;
            }
            case WORLD: {
                PresetHandler.importWorldPreset(serverPlayer.m_183503_(), message.getResourceLocation(), easyNPC.getEntity().m_20182_(), uuid);
                break;
            }
            default: {
                log.error("Invalid preset type {} from {}", (Object)message.getPresetType(), (Object)serverPlayer);
            }
        }
    }

    public FriendlyByteBuf encode() {
        return ImportPresetMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public PresetType getPresetType() {
        return this.presetType;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public CompoundTag getCompoundTag() {
        return this.compoundTag;
    }
}

