/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageBasicTrading
extends NetworkMessage {
    protected final int tradingValue;
    protected final TradingValueType tradingValueType;

    public MessageBasicTrading(UUID uuid, TradingValueType tradingValueType, int tradingValue) {
        super(uuid);
        this.tradingValueType = tradingValueType;
        this.tradingValue = tradingValue;
    }

    public static MessageBasicTrading decode(FriendlyByteBuf buffer) {
        return new MessageBasicTrading(buffer.m_130259_(), (TradingValueType)buffer.m_130066_(TradingValueType.class), buffer.readInt());
    }

    public static void encode(MessageBasicTrading message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getTradingValueType());
        buffer.writeInt(message.getTradingValue());
    }

    public static void handle(MessageBasicTrading message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageBasicTrading.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageBasicTrading message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        TradingValueType tradingValueType = message.getTradingValueType();
        if (tradingValueType == null) {
            log.error("Trading value type {} is unknown for {}", (Object)tradingValueType, (Object)serverPlayer);
            return;
        }
        int tradingValue = message.getTradingValue();
        if (tradingValue < 0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)tradingValue, (Object)tradingValueType, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (tradingValueType) {
            case RESETS_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.setTradingResetsEveryMin(tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set max uses to {} for {} from {}", (Object)tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.setBasicTradingMaxUses(tradingValue);
                tradingData.updateBasicTradingOffers();
                break;
            }
            case REWARD_EXP: {
                log.debug("Set reward exp to {} for {} from {}", (Object)tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.setBasicTradingRewardExp(tradingValue);
                tradingData.updateBasicTradingOffers();
                break;
            }
            default: {
                log.error("Trading value type {} is unknown for {}", (Object)tradingValueType, (Object)serverPlayer);
            }
        }
    }

    public TradingValueType getTradingValueType() {
        return this.tradingValueType;
    }

    public int getTradingValue() {
        return this.tradingValue;
    }

    public static enum TradingValueType {
        RESETS_EVERY_MIN,
        MAX_USES,
        REWARD_EXP;

    }
}

