/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelEquipmentVisibilityChange
extends NetworkMessage {
    protected final EquipmentSlot equipmentSlot;
    protected final boolean visible;

    public MessageModelEquipmentVisibilityChange(UUID uuid, EquipmentSlot equipmentSlot, boolean visible) {
        super(uuid);
        this.equipmentSlot = equipmentSlot;
        this.visible = visible;
    }

    public static MessageModelEquipmentVisibilityChange decode(FriendlyByteBuf buffer) {
        return new MessageModelEquipmentVisibilityChange(buffer.m_130259_(), (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class), buffer.readBoolean());
    }

    public static void encode(MessageModelEquipmentVisibilityChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getEquipmentSlot());
        buffer.writeBoolean(message.isVisible());
    }

    public static void handle(MessageModelEquipmentVisibilityChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelEquipmentVisibilityChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelEquipmentVisibilityChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EquipmentSlot equipmentSlot = message.getEquipmentSlot();
        if (equipmentSlot == null) {
            log.error("Invalid equipmentSlot for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        boolean visible = message.isVisible();
        log.debug("Change {} visibility to {} for {} from {}", (Object)equipmentSlot, (Object)visible, easyNPC, (Object)serverPlayer);
        switch (equipmentSlot) {
            case HEAD: {
                modelData.setModelHelmetVisible(visible);
                break;
            }
            case CHEST: {
                modelData.setModelChestplateVisible(visible);
                break;
            }
            case LEGS: {
                modelData.setModelLeggingsVisible(visible);
                break;
            }
            case FEET: {
                modelData.setModelBootsVisible(visible);
                break;
            }
            default: {
                log.error("Invalid equipmentSlot {} for {} from {}", (Object)equipmentSlot, (Object)message, (Object)serverPlayer);
            }
        }
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

