/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageObjectiveAdd
extends NetworkMessage {
    protected final ObjectiveDataEntry objectiveDataEntry;

    public MessageObjectiveAdd(UUID uuid, ObjectiveDataEntry objectiveDataEntry) {
        super(uuid);
        this.objectiveDataEntry = objectiveDataEntry;
    }

    public static MessageObjectiveAdd decode(FriendlyByteBuf buffer) {
        return new MessageObjectiveAdd(buffer.m_130259_(), new ObjectiveDataEntry(buffer.m_130260_()));
    }

    public static void encode(MessageObjectiveAdd message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130079_(message.objectiveDataEntry.createTag());
    }

    public static void handle(MessageObjectiveAdd message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageObjectiveAdd.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageObjectiveAdd message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ObjectiveDataEntry objectiveDataEntry = message.getObjectiveDataEntry();
        if (objectiveDataEntry == null) {
            log.error("Unable to add objective data for {} because it is null!", (Object)uuid);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null) {
            log.error("Invalid objective data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        if (objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            log.debug("Added objective {} for {} from {}", (Object)objectiveDataEntry, easyNPC, (Object)serverPlayer);
            log.debug("Available goals for {}: {}", easyNPC, (Object)objectiveData.getEntityGoalSelector().m_148105_());
            log.debug("Available targets for {}: {}", easyNPC, (Object)objectiveData.getEntityTargetSelector().m_148105_());
        }
    }

    public ObjectiveDataEntry getObjectiveDataEntry() {
        return this.objectiveDataEntry;
    }
}

