/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageProfessionChange
extends NetworkMessage {
    protected final Profession profession;

    public MessageProfessionChange(UUID uuid, Profession profession) {
        super(uuid);
        this.profession = profession;
    }

    public static MessageProfessionChange decode(FriendlyByteBuf buffer) {
        return new MessageProfessionChange(buffer.m_130259_(), (Profession)buffer.m_130066_(Profession.class));
    }

    public static void encode(MessageProfessionChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getProfession());
    }

    public static void handle(MessageProfessionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageProfessionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageProfessionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Profession profession = message.getProfession();
        if (profession == null) {
            log.error("Invalid profession {} for {} from {}", (Object)profession, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ProfessionData<?> professionData = easyNPC.getEasyNPCProfessionData();
        if (professionData == null) {
            log.error("Invalid profession data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        log.debug("Change profession {} for {} from {}", (Object)profession, easyNPC, (Object)serverPlayer);
        professionData.setProfession(profession);
    }

    public Profession getProfession() {
        return this.profession;
    }
}

